/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.dmp.utils;

import com.digiwin.dmp.constant.ImpalaUtilConstants;
import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.List;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileStatus;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.LocalFileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hdfs.DistributedFileSystem;
import org.apache.hadoop.hdfs.web.WebHdfsFileSystem;

public class HadoopUtil {
    public static Configuration getHdfsConfiguration(String env) {
        Configuration conf = new Configuration();
        conf.set("fs.defaultFS", ImpalaUtilConstants.webHDFSConf.get(env));
        conf.set("fs.hdfs.impl", DistributedFileSystem.class.getName());
        conf.set("fs.webhdfs.impl", WebHdfsFileSystem.class.getName());
        conf.set("fs.file.impl", LocalFileSystem.class.getName());
        System.setProperty("HADOOP_USER_NAME", "impala");
        return conf;
    }

    public static List<Path> getHDFSNeedMergeFile(String path, String env) {
        ArrayList<Path> needMergeFileList = new ArrayList<Path>();
        try {
            FileStatus[] fileStatuses;
            FileSystem fileSystem = FileSystem.get((Configuration)HadoopUtil.getHdfsConfiguration(env));
            for (FileStatus fileStatus : fileStatuses = fileSystem.listStatus(new Path(path))) {
                if (fileStatus.getLen() > 0xA00000L) continue;
                needMergeFileList.add(fileStatus.getPath());
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return needMergeFileList;
    }

    public static void main(String[] args) throws IOException, URISyntaxException {
        FileStatus[] fileStatuses;
        FileSystem fs = FileSystem.get((Configuration)HadoopUtil.getHdfsConfiguration("test_dev"));
        Path path = new Path(new URI("/tmp/aa=111"));
        fs.mkdirs(path);
        for (FileStatus fileStatus : fileStatuses = fs.listStatus(new Path("/tmp"))) {
            System.out.println(fileStatus.getPath());
        }
        fs.close();
    }
}

