/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.dmp.utils;

import com.alibaba.druid.util.StringUtils;
import com.digiwin.dmp.utils.ConfigReader;
import java.io.Serializable;
import java.util.Arrays;
import java.util.List;
import org.apache.log4j.LogManager;
import org.apache.log4j.Logger;

public final class ImpalaJdbcUtil
implements Serializable {
    private static final Logger logger = LogManager.getLogger(ImpalaJdbcUtil.class);
    private static final long serialVersionUID = 1L;

    private ImpalaJdbcUtil() {
        throw new RuntimeException("\u6b64\u7c7b\u4e0d\u5141\u8bb8\u5b9e\u4f8b\u5316");
    }

    public static String getImpalaJdbcUrl(String env, String type, String database, String lable) {
        String jdbcUrl;
        if ("hive".equals(type)) {
            type = "hive2";
        }
        List<String> impalaAliveNodes = Arrays.asList(ConfigReader.getValue("impala.url." + env).split(","));
        if ("test_hw".equals(env) || "prod_hw".equals(env) || "test_dev".equals(env) || "prod_azure".equals(env)) {
            if (!StringUtils.isEmpty(lable)) {
                int index = Math.abs(lable.hashCode() % impalaAliveNodes.size());
                String impalaUrl = impalaAliveNodes.get(index);
                jdbcUrl = String.format("jdbc:%s://%s/%s;auth=noSasl", type, impalaUrl, database);
            } else {
                jdbcUrl = ImpalaJdbcUtil.getImpalaHAJdbcUrl(env, type, database);
            }
        } else {
            logger.error("getImpalaJdbcUrl\u5f02\u5e38\uff0c\u8bf7\u68c0\u67e5\u914d\u7f6eenv\u914d\u7f6e");
            throw new RuntimeException("getImpalaJdbcUrl\u5f02\u5e38\uff0c\u8bf7\u68c0\u67e5\u914d\u7f6eenv\u914d\u7f6e");
        }
        return jdbcUrl;
    }

    public static String getImpalaHAJdbcUrl(String env, String type, String database) {
        if ("hive".equals(type)) {
            type = "hive2";
        }
        return String.format("jdbc:%s://%s/%s;auth=noSasl", type, ConfigReader.getValue("impala.url.ha." + env), database);
    }
}

