package com.digiwin.athena.atdm.audc;

import com.digiwin.athena.aim.sdk.manager.AudcManager;
import com.digiwin.athena.aim.sdk.meta.dto.request.AccessibleReqDTO;
import com.digiwin.athena.aim.sdk.meta.dto.response.AccessibleRespDTO;
import lombok.extern.slf4j.Slf4j;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

/**
 * AudcServiceImpl Description
 *
 * @author majianfu
 * @date 2022/2/15
 * @since
 */
@Slf4j
@Service
public class OpenAudcServiceImpl implements OpenAudcService {
    @Override
    public List<AccessibleRespDTO> checkTypeActivitiesAccessible(List<String> activityId) {
        if (CollectionUtils.isEmpty(activityId)) {
            return Collections.emptyList();
        }
        List<AccessibleReqDTO> typeActivitiesList = new ArrayList<>();
        AccessibleReqDTO accessibleReqDTO = new AccessibleReqDTO();
        accessibleReqDTO.setType("0");
        accessibleReqDTO.setTmActivityIdList(activityId);
        typeActivitiesList.add(accessibleReqDTO);

        return AudcManager.checkAccessible(typeActivitiesList).data();
    }
}
