package com.digiwin.athena.atdm.iam;

import com.digiwin.athena.appcore.auth.GlobalConstant;
import com.digiwin.athena.appcore.util.ExceptionUtil;
import com.digiwin.athena.appcore.util.JsonUtils;
import com.digiwin.athena.atdm.constant.ErrorCodeEnum;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.http.HttpEntity;
import org.springframework.http.HttpHeaders;
import org.springframework.http.MediaType;
import org.springframework.http.ResponseEntity;
import org.springframework.stereotype.Service;
import org.springframework.web.client.RestTemplate;

import java.util.HashMap;
import java.util.Map;

@Slf4j
@Service
public class OpenUserServiceImpl implements OpenUserService {
    @Value("${iam.uri:}")
    private String iamUri;

    @Autowired
    protected RestTemplate restTemplate;

    /**
     * {@inheritDoc}
     */
    @Override
    public Integer queryUserType(String userId, String token) {
        // 获取员工ID
        HttpHeaders headers = new HttpHeaders();
        headers.setContentType(MediaType.APPLICATION_JSON);
        headers.add(GlobalConstant.IAM_USER_TOKEN, token);
        // post body
        Map<String, String> param = new HashMap<>();
        param.put("userId", userId);
        HttpEntity<?> httpEntity = new HttpEntity<>(param, headers);
        String url = iamUri + "/api/iam/v2/query/user";
        try {
            ResponseEntity<Map> responseEntity = restTemplate.postForEntity(url, httpEntity, Map.class);
            Map body = responseEntity.getBody();
            if (body == null) {
                return null;
            } else {
                return (Integer) body.get("userType");
            }
        } catch (Exception ex) {
            log.error("{}, body: {}, error: ", ErrorCodeEnum.IAM_V2_QUERY_USER.getErrCode(), JsonUtils.objectToString(param), ex);
            throw ExceptionUtil.wrap(ErrorCodeEnum.IAM_V2_QUERY_USER.getErrCode(), ex);
        }
    }
}
