package com.digiwin.athena.atdm.importstatistics.application;

import com.digiwin.athena.atdm.importstatistics.application.mechanism.Mechanism;
import lombok.Data;

import java.util.List;

@Data
public class Application extends LanguageEntity {
    private String code;
    private String name;
    /*
     *  适用的场景/行业
    */
    private List<Tag> tags;
    /**
     * 应用包含的机制
     */
    private List<Mechanism> mechanisms;

    //应用的描述说明
    private String description;
    //应用的参数
    private List<FieldDescription> paramDescription;

    //参数来源api
    private List<ParamApi> paramApi;

    //是否已设定
    private boolean hasSet;

    //应用的清单
    private List<FieldDescription> manifest;

    //应用类型 增强型应用enhance
    private String category;

    //应用扩展类型 增强型应用数字员工为 digitalStaff
    private String extendType;

    //应用扩展数据 增强型应用数字员工为 数字员工code
    private String extendData;

    //应用扩展数据 增强型应用数字员工为 数字员工名称
    private String extendDisplay;

    //返回给前端的 增强应用显示
    private List enhance;

    private List<String> paradigms;

}