package com.digiwin.athena.atdm.importstatistics.util;

import org.apache.commons.lang.StringUtils;
import org.springframework.util.CollectionUtils;

import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;

public class MyCollectionUtils {

    public static final String DEFAULT_DELIMITER = "&&";

    public static <T, R> Map<String, List<T>> groupingBy(List<T> list, Function<T, R>[] functions) {
        return list.stream().collect(Collectors.groupingBy(t -> groupingBy(t, functions)));
    }

    public static String getJoinedKey(List<String> keys) {
        StringBuilder sb = new StringBuilder();
        for (String s : keys) {
            if (s != null && !"".equals(s)) {
                sb.append(DEFAULT_DELIMITER).append(s);
            }
        }
        return sb.toString();
    }

    public static <T, R> String groupingBy(T t, Function<T, R>[] functions) {
        if (functions == null || functions.length == 0) {
            throw new NullPointerException("functions数组不可以为空");
        } else if (functions.length == 1) {
            return functions[0].apply(t).toString();
        } else {
            return Arrays.stream(functions)
                    .map(fun -> String.valueOf(fun.apply(t)))
                    .reduce((str1, str2) -> str1 + DEFAULT_DELIMITER + str2)
                    .orElse(StringUtils.EMPTY);
        }
    }

    public static Function<Map, Object>[] formMapGroupFunctions(List<String> keys) {
        if (CollectionUtils.isEmpty(keys)) {
            throw new NullPointerException("keys数组不可以为空");
        }
        Function[] functionArray = new Function[keys.size()];
        for (int i = 0; i < keys.size(); i++) {
            int finalI = i;
            Function<Map, Object> get = p -> p.get(keys.get(finalI));
            functionArray[i] = get;
        }
        return functionArray;
    }

}
