package com.digiwin.athena.atdm.kg;


import com.digiwin.athena.appcore.auth.AppAuthContextHolder;
import com.digiwin.athena.appcore.auth.domain.AuthoredUser;
import com.digiwin.athena.appcore.exception.BusinessException;
import com.digiwin.athena.atdm.constant.ErrorCodeEnum;
import com.digiwin.athena.atdm.importstatistics.common.api.DapResponse;
import com.digiwin.athena.atdm.importstatistics.dto.ApplicationRelationQueryDTO;
import com.digiwin.athena.atdm.importstatistics.util.Utils;
import com.digiwin.athena.atdm.util.MessageUtil;
import lombok.extern.slf4j.Slf4j;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang.StringUtils;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.context.i18n.LocaleContextHolder;
import org.springframework.stereotype.Service;

import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;

/**
 * @program: athena_backend
 * @description: 描述
 * @author: Tuo
 * @create: 2021-04-29 13:43
 **/
@Slf4j
@Service
public class OpenDataEntryKgService {

    @Value("${themeMap.uri}")
    private String knowledgeGraphUrl;


    private final String APPLICATION_NAMEANDTAG_CONFIG = "knowledgegraph/app/byNameAndTags";
    private final String QUERY_DIGITALSTAFF = "knowledgegraph/app/queryDigitalStaffByCode";

    private final String GET_ENHANCE_BYAPPCODE = "knowledgegraph/app/enhanceByAppCode";

    private final String BY_CODES_AND_TYPE = "knowledgegraph/app/ApplicationRelationsByCodesAndType";

    private final String APPLICATION_BY_TYPE_AND_CODE = "knowledgegraph/app/ApplicationByTypeAndCode";

    private String kghost=null;

    public DapResponse getApplicationByNameAndTags(String applicationName, List<String> tags) {
        Map<String, Object> params = new HashMap<>();
        if (applicationName != null && !applicationName.isEmpty()) {
            params.put("applicationName", applicationName);
        }else {
            params.put("applicationName", "");
        }
        if (tags != null && !tags.isEmpty()) {
            params.put("tags", tags);
        }else {
            params.put("tags", new ArrayList<String>(){});
        }
        DapResponse response = requestKg(APPLICATION_NAMEANDTAG_CONFIG,"get",params);
        return response;
    }

    public  DapResponse requestKg(String service, String httpMethod, Map<String,Object> params){

        String url = knowledgeGraphUrl+ service;
        Map<String,String> headers = new HashMap<>();
        headers.put("designer","deliveryDesigner");
        if(null==kghost){
            try {
                URL  u = new URL(knowledgeGraphUrl);
                kghost = u.getHost();
            } catch (MalformedURLException e) {
                log.error(e.toString());
            }
        }
        headers.put("Host",kghost);
        AuthoredUser user = AppAuthContextHolder.getContext().getAuthoredUser();
        if(null!=user){
            headers.put("token", user.getToken());
            headers.put("routerKey",user.getTenantId());
            headers.put("locale", LocaleContextHolder.getLocale().toString());
        }
        DapResponse result = null;
        if("post".equalsIgnoreCase(httpMethod)){
            result= Utils.postJson(url,headers,params,DapResponse.class);
        }
        else if("delete".equalsIgnoreCase(httpMethod)){
            result= Utils.deleteJson(url,headers,params,DapResponse.class);
        }
        else{
            result= Utils.get(url,headers,params,DapResponse.class);
        }
        return result;

    }

    public DapResponse getDigitalStaff(Set<String> codeList, Set<String> enhanceCodeList) {
        if (CollectionUtils.isEmpty(codeList)) {
            throw BusinessException.create(ErrorCodeEnum.NUM_500_0088.getErrCode(), MessageUtil.getMessage("delivery.codeListEmpty"));
        }
        Map<String, Object> params = new HashMap<>();
        params.put("codeList", codeList);
        params.put("enhanceCodeList", enhanceCodeList);
        DapResponse response = requestKg(QUERY_DIGITALSTAFF,"post",params);
        return response;
    }

    public DapResponse getEnhancebyAppCode(String code) {
        if (StringUtils.isEmpty(code)) {
            throw BusinessException.create(ErrorCodeEnum.NUM_500_0089.getErrCode(),MessageUtil.getMessage("delivery.delivery.codeEmpty"));
        }
        Map<String, Object> params = new HashMap<>();
        params.put("code", code);
        DapResponse response = requestKg(GET_ENHANCE_BYAPPCODE,"get",params);
        return response;
    }

    public DapResponse postApplicationRelationsByCodesAndType(List<String> code, String type) {
        Map<String, Object> params = new HashMap<>();
        ApplicationRelationQueryDTO applicationRelationQueryDTO = new ApplicationRelationQueryDTO();
        applicationRelationQueryDTO.setCodes(code);
        applicationRelationQueryDTO.setType(type);
        params.put("applicationRelationQueryDTO", applicationRelationQueryDTO);
        DapResponse response = requestKg(BY_CODES_AND_TYPE, "post", params);
        return response;
    }

    public DapResponse getApplicationByTypeAndCode(String type, String code) {
        Map<String, Object> params = new HashMap<>();
        params.put("type", type);
        params.put("code", code);
        DapResponse response = requestKg(APPLICATION_BY_TYPE_AND_CODE, "get", params);
        return response;
    }

}
