package com.digiwin.athena.atdm.semc;

import com.digiwin.athena.appcore.auth.AppAuthContextHolder;
import com.digiwin.athena.appcore.auth.GlobalConstant;
import com.digiwin.athena.appcore.auth.domain.AuthoredUser;
import com.digiwin.athena.appcore.domain.BaseResultDTO;
import com.digiwin.athena.atdm.semc.dto.EncryptedConfigDTO;
import com.digiwin.athena.atdm.semc.dto.EncryptedConfigVO;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.core.ParameterizedTypeReference;
import org.springframework.http.HttpEntity;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpMethod;
import org.springframework.http.ResponseEntity;
import org.springframework.stereotype.Service;
import org.springframework.web.client.RestTemplate;

import java.util.HashMap;
import java.util.Map;

/**
 * @author mk
 * @date 2024/10/19 15:32
 * @description: 智能入口数据获取
 */
@Slf4j
@Service
public class OpenTddServiceImpl implements OpenTddService {
    @Value("${tdd.uri:}")
    private String tddUri;

    @Autowired
    private RestTemplate restTemplate;


    @Override
    public EncryptedConfigVO getEncryptedConfig(EncryptedConfigDTO encryptedConfigDTO) {
        AuthoredUser authoredUser = AppAuthContextHolder.getContext().getAuthoredUser();
        AuthoredUser proxyAuthoredUser = AppAuthContextHolder.getContext().getProxyAuthoredUser();
        String url = tddUri + "/encrypted/getEncryptedConfig";
        try {
            HttpHeaders headers = new HttpHeaders();
            headers.add(GlobalConstant.IAM_USER_TOKEN, proxyAuthoredUser != null ? proxyAuthoredUser.getToken() : authoredUser.getToken());
            HttpEntity<EncryptedConfigDTO> requestEntity = new HttpEntity<>(encryptedConfigDTO,headers);
            ResponseEntity<BaseResultDTO<EncryptedConfigVO>> resultDTOResponseEntity = restTemplate.exchange(url, HttpMethod.POST, requestEntity,
                    new ParameterizedTypeReference<BaseResultDTO<EncryptedConfigVO>>() {
                    });
            return resultDTOResponseEntity.getBody().getResponseWithException("");
        } catch (Exception e) {
            log.error(e.getMessage(), e);
            return null;
        }
    }

    @Override
    public String makePassword(Integer passwordStreflgth, Integer passwordLength) {
        String url = tddUri + "/encrypted/makePassword";
        Map<String, Object> params = new HashMap<>();
        params.put("defenceComplexity", passwordStreflgth);
        params.put("defenceLength", passwordLength);
        HttpHeaders headerMap = new HttpHeaders();
        HttpEntity httpEntity = new HttpEntity(params, headerMap);
        ResponseEntity<BaseResultDTO<Map>> respEntity = restTemplate.exchange(url, HttpMethod.POST, httpEntity,
                new ParameterizedTypeReference<BaseResultDTO<Map>>() {
                });
        Map responseWithException = respEntity.getBody().getResponseWithException("");
        if (responseWithException.containsKey("defence")) {
            return responseWithException.get("defence") + "";
        }
        return null;
    }
}
