package com.digiwin.athena.atdm.service.impl;

import com.digiwin.athena.appcore.exception.BusinessException;
import com.digiwin.athena.atdm.constant.ErrorCodeEnum;
import com.digiwin.athena.atdm.importstatistics.dto.ExportStatisticsDTO;
import com.digiwin.athena.atdm.importstatistics.util.excel.ExcelTypeEnum;
import com.digiwin.athena.atdm.service.OpenDataEntryDmcService;
import com.digiwin.athena.atdm.util.MessageUtil;
import lombok.extern.slf4j.Slf4j;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import javax.servlet.http.HttpServletResponse;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URLEncoder;

/**
 * @ClassName ExportStatisticsDomainService
 * @Description 导出数据领域服务
 * @Author lisheng
 * @Date 2023/9/20 17:51
 * @Version 1.0
 **/
@Slf4j
@Service
public class OpenDataEntryExportStatisticsDomainService {
    @Autowired
    OpenDataEntryDmcService dmcService;
    private static final String EXCEL_SUFFIX = ".xlsx";


    public void downloadExportFile(ExportStatisticsDTO exportStatisticsDTO, HttpServletResponse response) {
        final String fileUrl = exportStatisticsDTO.getFileUrl();
        if (StringUtils.isEmpty(fileUrl)) {
            throw BusinessException.create(ErrorCodeEnum.NUM_500_0066.getErrCode(), MessageUtil.getMessage("delivery.notFoundExportExcel"));
        }
        response.setContentType(ExcelTypeEnum.XLSX.value());
        //设置文件名
        response.setCharacterEncoding("utf-8");
        String formFileName = exportStatisticsDTO.getFileName() + EXCEL_SUFFIX;
        try (InputStream inputStream = dmcService.getExportFileInputStream(fileUrl);
             OutputStream os = response.getOutputStream()) {
            formFileName = URLEncoder.encode(formFileName, "UTF-8");
            // 解决URLEncoder.encode方法会把空格变成加号（+）在前台页面显示的时候会多出加号的问题
            formFileName = formFileName.replaceAll("\\+", "%20");
            response.addHeader("Content-Disposition", "attachment;filename=" + formFileName);
            response.addHeader("Access-Control-Expose-Headers", "Content-Disposition");
            IOUtils.copy(inputStream, os);
        } catch (IOException e) {
            log.error("导出异常数据写入文件异常", e);
        }
    }
}
