package com.digiwin.athena.atdm.service.impl;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.digiwin.athena.appcore.exception.BusinessException;
import com.digiwin.athena.atdm.constant.ErrorCodeEnum;
import com.digiwin.athena.atdm.importstatistics.configuration.OpenDMCConfig;
import com.digiwin.athena.atdm.importstatistics.entity.OpenDMCTokenBean;
import com.digiwin.athena.atdm.importstatistics.entity.ImportStatistics;
import com.digiwin.athena.atdm.importstatistics.util.excel.ExcelTypeEnum;
import com.digiwin.athena.atdm.importstatistics.util.excel.ExcelUtil;
import com.digiwin.athena.atdm.service.OpenDataEntryErrorHandlerService;
import lombok.extern.slf4j.Slf4j;
import org.apache.poi.ss.usermodel.Cell;
import org.apache.poi.ss.usermodel.Row;
import org.apache.poi.ss.usermodel.Sheet;
import org.apache.poi.xssf.usermodel.XSSFWorkbook;
import org.springframework.amqp.rabbit.core.RabbitTemplate;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.http.HttpEntity;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpMethod;
import org.springframework.http.MediaType;
import org.springframework.http.ResponseEntity;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;
import org.springframework.util.StringUtils;
import org.springframework.web.client.RestTemplate;

import javax.annotation.Resource;
import javax.servlet.http.HttpServletResponse;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;

/**
 * @ClassName RabbitErrorHandlerServiceImpl
 * @Description TODO
 * @Author zhuangli
 * @Date 2021/4/25 16:35
 * @Version 1.0
 **/
@Service
@Slf4j
public class OpenRabbitOpenDataEntryErrorHandlerServiceImpl implements OpenDataEntryErrorHandlerService {

    @Autowired
    RabbitTemplate rabbitTemplate;

    @Resource
    RestTemplate dmcRestTemplate;

    @Autowired
    OpenDMCConfig dmcConfig;

    @Autowired
    OpenDMCTokenBean dmcTokenBean;

    @Value("${rest-url.dmc}")
    private String dmcUrl;
    @Value("${rest-url.appToken}")
    private String appToken;
    private final String EXCEL_SUFFIX = ".xlsx";
    private final String BASE_URL = this.getClass().getClassLoader().getResource("").getFile();
    private final String PACKAGE_NAME = "importError";
    private final String HEADER_KEY = "key";
    private final String HEADER_NAME = "name";
    private final String SHEET_NAME = "sheet1";


    private InputStream getErrorTableInputStream(String failedUrl) {
        HttpHeaders headers = new HttpHeaders();
        headers.add("digi-middleware-auth-user", dmcTokenBean.getToken());
        headers.add("digi-middleware-auth-app", appToken);
        List list = new ArrayList<>();
        list.add(MediaType.parseMediaType(ExcelTypeEnum.XLSX.value()));
        headers.setAccept(list);
        String url = dmcUrl + "/api/dmc/v2/file/" + dmcConfig.getBucket() + "/download/" + failedUrl;
        ResponseEntity<byte[]> restRes = dmcRestTemplate.exchange(
                url,
                HttpMethod.GET,
                new HttpEntity<byte[]>(headers),
                byte[].class);
        return new ByteArrayInputStream(restRes.getBody());
    }

    @Override
    public void downloadErrorTable(ImportStatistics importStatistics, List<Map> headers, Set<String> requiredFields, HttpServletResponse response) {
        final String failedUrl = importStatistics.getFailedUrl();
        if (StringUtils.isEmpty(failedUrl)) {
            throw BusinessException.create(ErrorCodeEnum.NUM_500_0074.getErrCode(), "没有生成对应的文档");
        }
        response.setContentType(ExcelTypeEnum.XLSX.value());
        //设置文件名
        response.setCharacterEncoding("utf-8");
        String formFileName = getFileName(importStatistics);
        response.addHeader("Content-Disposition", "attachment;filename=" + formFileName + EXCEL_SUFFIX);
        response.addHeader("Access-Control-Expose-Headers", "Content-Disposition");
        InputStream inputStream = getErrorTableInputStream(failedUrl);
        //------------------
        XSSFWorkbook wb;
        try {
            wb = new XSSFWorkbook(inputStream);

        } catch (IOException e) {
            throw BusinessException.create(ErrorCodeEnum.NUM_500_0075.getErrCode(), "解析excel失败masterid:" + importStatistics.getMasterId());
        }
        Sheet sheet = wb.getSheetAt(0);
        Row headRow1 = sheet.getRow(0);
        Row headRow2 = sheet.getRow(1);
        Map<String, String> headerMap = new HashMap<>();
        if (!CollectionUtils.isEmpty(headers)) {
            headerMap = headers.stream().collect(Collectors.toMap(s -> (String) s.get(HEADER_KEY), s -> (String) s.get(HEADER_NAME)));
        }
        if (!CollectionUtils.isEmpty(headerMap)) {
            for (int i = 0; i < headRow1.getLastCellNum(); i++) {
                //创建单元格
                Cell cell1 = headRow1.getCell(i);
                Cell cell2 = headRow2.getCell(i);
                //设置值
                String langVal = headerMap.get(cell2.getStringCellValue());
                langVal = StringUtils.isEmpty(langVal) ? cell1.getStringCellValue() : langVal;
                if ((!CollectionUtils.isEmpty(requiredFields)) && requiredFields.contains((String) headers.get(i).get(HEADER_KEY))) {
                    cell1.setCellValue(ExcelUtil.addRequiredMark(wb, langVal));
                } else {
                    cell1.setCellValue(langVal);
                }
            }
        }

        try (OutputStream os = response.getOutputStream()) {
            wb.write(os);
            wb.close();
        } catch (IOException e) {
            if (null != wb) {
                try {
                    wb.close();
                } catch (IOException ioe) {
                    log.error("关闭wb异常", ioe);
                }
            }
            log.error("导出异常数据写入文件异常", e);
        }
        //------------------
        /*byte[] buffer = new byte[1024];
        BufferedInputStream bis = null;
        try {
            bis = new BufferedInputStream(inputStream);
            OutputStream os = response.getOutputStream();
            int i;
            while ((i = bis.read(buffer)) != -1) {
                os.write(buffer, 0, i);
            }
        } catch (Exception e) {
            e.printStackTrace();
        } finally {
            if (bis != null) {
                try {
                    bis.close();
                } catch (IOException e) {
                    e.printStackTrace();
                }
            }
        }*/
    }

    /**
     * 获取作业名称规则：根据locale来判断语言环境，如果locale为null则取default
     *
     * @param importStatistics
     * @return
     */
    private String getFileName(ImportStatistics importStatistics) {
        JSONObject jsonObject = JSON.parseObject(importStatistics.getActivityName());
        String fileName = "";
        String locale = importStatistics.getLocale();
        switch (locale) {
            case "zh_CN":
                fileName = jsonObject.getString("default");
                break;
            case "zh_TW":
                fileName = jsonObject.getString("zh_TW");
                break;
            case "en_US":
                fileName = jsonObject.getString("en_US");
                break;
            default:
                fileName = jsonObject.getString("default");
                break;
        }
        SimpleDateFormat simpleDateFormat = new SimpleDateFormat("yyyy-MM-dd HH_mm_ss");
        String formatTime = simpleDateFormat.format(importStatistics.getCreateTime());
        fileName = fileName + " " + formatTime;

        try {
            fileName = URLEncoder.encode(fileName, "UTF-8");
        } catch (UnsupportedEncodingException e) {
            e.printStackTrace();
        }
        // 解决URLEncoder.encode方法会把空格变成加号（+）在前台页面显示的时候会多出加号的问题
        fileName = fileName.replaceAll("\\+", "%20");
        return fileName;
    }
}
