/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.mcp.config;

import com.digiwin.mcp.interceptor.OkHttpRetryInterceptor;
import java.util.concurrent.TimeUnit;
import okhttp3.Interceptor;
import okhttp3.OkHttpClient;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;

@Configuration
public class OkHttpConfig {
    @Value(value="${ok.http.connect-timeout}")
    private Integer connectTimeout = 30;
    @Value(value="${ok.http.read-timeout}")
    private Integer readTimeout = 30;
    @Value(value="${ok.http.write-timeout}")
    private Integer writeTimeout = 30;
    @Value(value="${ok.http.max-idle-connections}")
    private Integer maxIdleConnections = 200;
    @Value(value="${ok.http.keep-alive-duration}")
    private Integer keepAliveDuration = 300;
    @Value(value="${ok.http.retry.count}")
    private Integer retryCount = 3;
    @Value(value="${ok.http.retry-delay-mills}")
    private Integer retryDelayMills = 100;

    @Bean
    public OkHttpClient myOkHttpClient() {
        return new OkHttpClient().newBuilder().connectTimeout((long)this.connectTimeout.intValue(), TimeUnit.SECONDS).readTimeout((long)this.readTimeout.intValue(), TimeUnit.SECONDS).writeTimeout((long)this.writeTimeout.intValue(), TimeUnit.SECONDS).retryOnConnectionFailure(true).addInterceptor((Interceptor)new OkHttpRetryInterceptor(this.retryCount, this.retryDelayMills)).build();
    }
}

