/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.mcp.interceptor;

import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import org.apache.commons.io.IOUtils;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.http.HttpRequest;
import org.springframework.http.client.ClientHttpRequestExecution;
import org.springframework.http.client.ClientHttpRequestInterceptor;
import org.springframework.http.client.ClientHttpResponse;
import org.springframework.stereotype.Component;

@Component
public class HttpRequestLogInterceptor
implements ClientHttpRequestInterceptor {
    private static final Logger log = LoggerFactory.getLogger(HttpRequestLogInterceptor.class);

    @NotNull
    public ClientHttpResponse intercept(@NotNull HttpRequest request, @NotNull byte[] body, ClientHttpRequestExecution execution) throws IOException {
        this.requestLog(request, body);
        ClientHttpResponse response = execution.execute(request, body);
        this.responseLog(response);
        return response;
    }

    private void requestLog(HttpRequest request, byte[] body) {
        log.info("Uri:{},Method:{},Headers:{},Request Body:{}", new Object[]{request.getURI(), request.getMethod(), request.getHeaders(), new String(body, StandardCharsets.UTF_8)});
    }

    private void responseLog(ClientHttpResponse response) throws IOException {
        log.info("Status Code:{},Response Body:{}", (Object)response.getStatusCode(), (Object)IOUtils.toString((InputStream)response.getBody(), (Charset)StandardCharsets.UTF_8));
    }
}

