/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.mcp.interceptor;

import com.digiwin.mcp.entity.McpFunctionInfo;
import com.digiwin.mcp.util.JsonUtil;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.node.ObjectNode;
import java.lang.reflect.Method;
import java.lang.reflect.Parameter;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import okhttp3.MediaType;
import okhttp3.OkHttpClient;
import okhttp3.Request;
import okhttp3.RequestBody;
import okhttp3.Response;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.http.HttpMethod;
import org.springframework.http.HttpStatus;
import org.springframework.http.ResponseEntity;
import org.springframework.util.CollectionUtils;
import org.springframework.util.StringUtils;
import org.springframework.web.bind.annotation.RequestHeader;
import org.springframework.web.server.MethodNotAllowedException;

public class McpStreamableHttpHandler {
    private static final Logger log = LoggerFactory.getLogger(McpStreamableHttpHandler.class);
    @Value(value="${iam.url}")
    private String iamUrl;
    @Value(value="${iam.appToken}")
    private String appToken;
    private String name;
    private String version;
    private List<McpFunctionInfo> functionInfos = new ArrayList();
    private Object targetBean;
    private final OkHttpClient okHttpClient;
    private final ObjectMapper objectMapper = new ObjectMapper();
    private String ERR_MESSAGE = "\u7528\u6236token\u5931\u6548\uff0c\u8bf7\u91cd\u65b0\u767b\u5f55\u6216\u8054\u7cfb\u5ba2\u670d\u4e13\u5458";

    public McpStreamableHttpHandler(OkHttpClient okHttpClient) {
        this.okHttpClient = okHttpClient;
    }

    public ResponseEntity<ObjectNode> handleGet() {
        throw new MethodNotAllowedException(HttpMethod.GET, null);
    }

    public ResponseEntity<ObjectNode> handlePost(@org.springframework.web.bind.annotation.RequestBody String body, @RequestHeader Map<String, String> headers) throws Exception {
        try {
            String method;
            ObjectNode request = (ObjectNode)this.objectMapper.readValue(body, ObjectNode.class);
            if (request == null || !request.has("id")) {
                return ResponseEntity.status((HttpStatus)HttpStatus.ACCEPTED).body(null);
            }
            String id = request.get("id").asText();
            switch (method = request.get("method").asText()) {
                case "initialize": {
                    return this.handleInitialize(id);
                }
                case "tools/list": {
                    return this.handleListTools(id);
                }
                case "tools/call": {
                    return this.handleCallTool(request, headers);
                }
            }
            return this.handleUnsupportedMethod(id, method);
        }
        catch (Exception e) {
            return ResponseEntity.status((HttpStatus)HttpStatus.INTERNAL_SERVER_ERROR).body(null);
        }
    }

    private ResponseEntity<ObjectNode> handleInitialize(String id) {
        ObjectNode response = this.objectMapper.createObjectNode();
        response.put("jsonrpc", "2.0");
        response.put("id", id);
        ObjectNode result = response.putObject("result");
        result.put("protocolVersion", "2024-11-05");
        ObjectNode capabilities = result.putObject("capabilities");
        ObjectNode serverInfo = result.putObject("serverInfo");
        serverInfo.put("name", this.name);
        serverInfo.put("version", this.version);
        return ResponseEntity.ok((Object)response);
    }

    private ResponseEntity<ObjectNode> handleUnsupportedMethod(String id, String method) {
        ObjectNode response = this.objectMapper.createObjectNode();
        response.put("jsonrpc", "2.0");
        response.put("id", id);
        ObjectNode error = response.putObject("error");
        error.put("code", -32601);
        error.put("message", "\u672c\u670d\u52a1\u5668\u4e0d\u652f\u6301 " + method + " \u65b9\u6cd5");
        return ResponseEntity.badRequest().body((Object)response);
    }

    private ResponseEntity<ObjectNode> handleListTools(String id) {
        log.info("\u83b7\u53d6\u5de5\u5177\u5217\u8868, \u8bf7\u6c42ID: {}", (Object)id);
        ObjectNode response = this.objectMapper.createObjectNode();
        response.put("jsonrpc", "2.0");
        response.put("id", id);
        ObjectNode result = response.putObject("result");
        result.putArray("tools");
        if (this.functionInfos != null && !this.functionInfos.isEmpty()) {
            for (McpFunctionInfo functionInfo : this.functionInfos) {
                ObjectNode tool = result.withArray("tools").addObject();
                tool.put("name", functionInfo.getName());
                tool.put("description", functionInfo.getDescription());
                if (functionInfo.getParams() == null || functionInfo.getParams().isEmpty()) continue;
                ObjectNode paramsNode = tool.putObject("inputSchema");
                paramsNode.put("type", "object");
                ObjectNode properties = paramsNode.putObject("properties");
                ArrayList<String> required = new ArrayList<String>();
                for (McpFunctionInfo.ParamInfo paramInfo : functionInfo.getParams()) {
                    if (paramInfo == null) continue;
                    ObjectNode paramNode = properties.putObject(paramInfo.getName());
                    paramNode.put("type", "string");
                    paramNode.put("description", paramInfo.getDescription());
                    if (paramInfo.getEnums() != null) {
                        for (String enumValue : paramInfo.getEnums()) {
                            paramNode.withArray("enum").add(enumValue);
                        }
                    }
                    if (!paramInfo.isRequired()) continue;
                    required.add(paramInfo.getName());
                }
                if (required.isEmpty()) continue;
                for (String req : required) {
                    paramsNode.withArray("required").add(req);
                }
            }
        }
        return ResponseEntity.ok((Object)response);
    }

    private ResponseEntity<ObjectNode> handleCallTool(ObjectNode request, Map<String, String> headers) {
        ObjectNode response = this.objectMapper.createObjectNode();
        response.put("jsonrpc", "2.0");
        response.put("id", request.get("id").asText());
        String toolName = null;
        ObjectNode params = null;
        if (request.has("params") && request.get("params").has("name")) {
            toolName = request.get("params").get("name").asText();
            if (request.get("params").has("arguments")) {
                params = (ObjectNode)request.get("params").get("arguments");
            }
        }
        if (!CollectionUtils.isEmpty(headers) && headers.containsKey("token")) {
            params.put("token", headers.get("token"));
            response.setAll(this.checkToken(headers, response));
            if (headers.get("routerKey") != null) {
                params.put("routerKey", headers.get("routerKey"));
            } else {
                params.put("routerKey", "");
            }
            if (headers.get("traceId") != null) {
                params.put("traceId", headers.get("traceId"));
            } else {
                params.put("traceId", "");
            }
        }
        McpFunctionInfo targetFunction = null;
        for (McpFunctionInfo functionInfo : this.functionInfos) {
            if (!functionInfo.getName().equals(toolName)) continue;
            targetFunction = functionInfo;
            break;
        }
        if (targetFunction != null && this.targetBean != null) {
            try {
                Method method = targetFunction.getMethod();
                Parameter[] parameters = method.getParameters();
                Object[] args = new Object[parameters.length];
                for (int i = 0; i < parameters.length; ++i) {
                    if (CollectionUtils.isEmpty((Collection)targetFunction.getParams())) {
                        log.error("\u672a\u68c0\u6d4b\u5230body\u53c2\u6570");
                        McpFunctionInfo.ParamInfo paramInfo = (McpFunctionInfo.ParamInfo)targetFunction.getHeaders().get(i);
                    }
                    McpFunctionInfo.ParamInfo paramInfo = i < targetFunction.getParams().size() ? (McpFunctionInfo.ParamInfo)targetFunction.getParams().get(i) : (McpFunctionInfo.ParamInfo)targetFunction.getHeaders().get(i - targetFunction.getParams().size());
                    String paramName = paramInfo.getName();
                    if (params != null && params.has(paramName)) {
                        args[i] = params.get(paramName).asText();
                        continue;
                    }
                    if (!paramInfo.isRequired()) continue;
                    log.warn("\u7f3a\u5c11\u5fc5\u9700\u53c2\u6570: {}", (Object)paramName);
                    ObjectNode error = response.putObject("error");
                    error.put("code", -32602);
                    error.put("message", "\u7f3a\u5c11\u5fc5\u9700\u53c2\u6570: " + paramName);
                    return ResponseEntity.ok((Object)response);
                }
                Object result = method.invoke(this.targetBean, args);
                ObjectNode resultNode = response.putObject("result");
                ArrayList content = new ArrayList();
                HashMap<String, String> textContent = new HashMap<String, String>();
                textContent.put("type", "text");
                textContent.put("text", result != null ? JsonUtil.getJsonString((Object)result) : "");
                content.add(textContent);
                resultNode.set("content", this.objectMapper.valueToTree(content));
            }
            catch (Exception e) {
                log.error("\u5de5\u5177 {} \u6267\u884c\u65f6\u53d1\u751f\u5f02\u5e38", (Object)toolName, (Object)e);
                ObjectNode error = response.putObject("error");
                error.put("code", -32603);
                error.put("message", "\u5de5\u5177 " + toolName + " \u6267\u884c\u65f6\u53d1\u751f\u5f02\u5e38" + e.getMessage());
            }
        } else {
            log.warn("\u627e\u4e0d\u5230\u6307\u5b9a\u7684\u5de5\u5177: {}", (Object)toolName);
            ObjectNode error = response.putObject("error");
            error.put("code", -32601);
            error.put("message", "\u627e\u4e0d\u5230\u6307\u5b9a\u7684\u5de5\u5177: " + toolName);
        }
        return ResponseEntity.ok((Object)response);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private ObjectNode checkToken(Map<String, String> headers, ObjectNode response) {
        String userToken = headers.get("token");
        if (StringUtils.isEmpty((Object)userToken)) {
            userToken = "";
        }
        HashMap bodys = new HashMap(0);
        String routerKey = headers.get("routerKey");
        log.info("UserLoginInterceptor routerKey is exist: {}", (Object)routerKey);
        RequestBody requestBody = RequestBody.create((String)JsonUtil.getJsonString(bodys), (MediaType)MediaType.parse((String)"application/json"));
        Request okHttpRequest = new Request.Builder().url(this.iamUrl + "/api/iam/v2/identity/token/analyze").method("POST", requestBody).header("digi-middleware-auth-app", this.appToken).header("digi-middleware-auth-user", userToken).build();
        try (Response okHttpResponse = this.okHttpClient.newCall(okHttpRequest).execute();){
            if (okHttpResponse.isSuccessful()) return response;
            ObjectNode objectNode = this.returnTokenCheckJson(response, (String)Optional.ofNullable(JsonUtil.json2Map((String)okHttpResponse.body().string())).map(e -> e.get("errorMessage")).orElse(this.ERR_MESSAGE));
            return objectNode;
        }
        catch (Exception e2) {
            return this.returnTokenCheckJson(response, this.ERR_MESSAGE);
        }
    }

    public ObjectNode returnTokenCheckJson(ObjectNode response, String returnMsg) {
        response.put("characterEncoding", "utf-8");
        response.put("contentType", "application/json; charset=utf-8");
        response.put("code", HttpStatus.UNAUTHORIZED.value());
        response.put("message", returnMsg);
        return response;
    }

    public String getIamUrl() {
        return this.iamUrl;
    }

    public String getAppToken() {
        return this.appToken;
    }

    public String getName() {
        return this.name;
    }

    public String getVersion() {
        return this.version;
    }

    public List<McpFunctionInfo> getFunctionInfos() {
        return this.functionInfos;
    }

    public Object getTargetBean() {
        return this.targetBean;
    }

    public OkHttpClient getOkHttpClient() {
        return this.okHttpClient;
    }

    public ObjectMapper getObjectMapper() {
        return this.objectMapper;
    }

    public String getERR_MESSAGE() {
        return this.ERR_MESSAGE;
    }

    public void setIamUrl(String iamUrl) {
        this.iamUrl = iamUrl;
    }

    public void setAppToken(String appToken) {
        this.appToken = appToken;
    }

    public void setName(String name) {
        this.name = name;
    }

    public void setVersion(String version) {
        this.version = version;
    }

    public void setFunctionInfos(List<McpFunctionInfo> functionInfos) {
        this.functionInfos = functionInfos;
    }

    public void setTargetBean(Object targetBean) {
        this.targetBean = targetBean;
    }

    public void setERR_MESSAGE(String ERR_MESSAGE) {
        this.ERR_MESSAGE = ERR_MESSAGE;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof McpStreamableHttpHandler)) {
            return false;
        }
        McpStreamableHttpHandler other = (McpStreamableHttpHandler)o;
        if (!other.canEqual((Object)this)) {
            return false;
        }
        String this$iamUrl = this.getIamUrl();
        String other$iamUrl = other.getIamUrl();
        if (this$iamUrl == null ? other$iamUrl != null : !this$iamUrl.equals(other$iamUrl)) {
            return false;
        }
        String this$appToken = this.getAppToken();
        String other$appToken = other.getAppToken();
        if (this$appToken == null ? other$appToken != null : !this$appToken.equals(other$appToken)) {
            return false;
        }
        String this$name = this.getName();
        String other$name = other.getName();
        if (this$name == null ? other$name != null : !this$name.equals(other$name)) {
            return false;
        }
        String this$version = this.getVersion();
        String other$version = other.getVersion();
        if (this$version == null ? other$version != null : !this$version.equals(other$version)) {
            return false;
        }
        List this$functionInfos = this.getFunctionInfos();
        List other$functionInfos = other.getFunctionInfos();
        if (this$functionInfos == null ? other$functionInfos != null : !((Object)this$functionInfos).equals(other$functionInfos)) {
            return false;
        }
        Object this$targetBean = this.getTargetBean();
        Object other$targetBean = other.getTargetBean();
        if (this$targetBean == null ? other$targetBean != null : !this$targetBean.equals(other$targetBean)) {
            return false;
        }
        OkHttpClient this$okHttpClient = this.getOkHttpClient();
        OkHttpClient other$okHttpClient = other.getOkHttpClient();
        if (this$okHttpClient == null ? other$okHttpClient != null : !this$okHttpClient.equals(other$okHttpClient)) {
            return false;
        }
        ObjectMapper this$objectMapper = this.getObjectMapper();
        ObjectMapper other$objectMapper = other.getObjectMapper();
        if (this$objectMapper == null ? other$objectMapper != null : !this$objectMapper.equals(other$objectMapper)) {
            return false;
        }
        String this$ERR_MESSAGE = this.getERR_MESSAGE();
        String other$ERR_MESSAGE = other.getERR_MESSAGE();
        return !(this$ERR_MESSAGE == null ? other$ERR_MESSAGE != null : !this$ERR_MESSAGE.equals(other$ERR_MESSAGE));
    }

    protected boolean canEqual(Object other) {
        return other instanceof McpStreamableHttpHandler;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $iamUrl = this.getIamUrl();
        result = result * 59 + ($iamUrl == null ? 43 : $iamUrl.hashCode());
        String $appToken = this.getAppToken();
        result = result * 59 + ($appToken == null ? 43 : $appToken.hashCode());
        String $name = this.getName();
        result = result * 59 + ($name == null ? 43 : $name.hashCode());
        String $version = this.getVersion();
        result = result * 59 + ($version == null ? 43 : $version.hashCode());
        List $functionInfos = this.getFunctionInfos();
        result = result * 59 + ($functionInfos == null ? 43 : ((Object)$functionInfos).hashCode());
        Object $targetBean = this.getTargetBean();
        result = result * 59 + ($targetBean == null ? 43 : $targetBean.hashCode());
        OkHttpClient $okHttpClient = this.getOkHttpClient();
        result = result * 59 + ($okHttpClient == null ? 43 : $okHttpClient.hashCode());
        ObjectMapper $objectMapper = this.getObjectMapper();
        result = result * 59 + ($objectMapper == null ? 43 : $objectMapper.hashCode());
        String $ERR_MESSAGE = this.getERR_MESSAGE();
        result = result * 59 + ($ERR_MESSAGE == null ? 43 : $ERR_MESSAGE.hashCode());
        return result;
    }

    public String toString() {
        return "McpStreamableHttpHandler(iamUrl=" + this.getIamUrl() + ", appToken=" + this.getAppToken() + ", name=" + this.getName() + ", version=" + this.getVersion() + ", functionInfos=" + this.getFunctionInfos() + ", targetBean=" + this.getTargetBean() + ", okHttpClient=" + this.getOkHttpClient() + ", objectMapper=" + this.getObjectMapper() + ", ERR_MESSAGE=" + this.getERR_MESSAGE() + ")";
    }
}

