package com.digiwin.athena.esp.proxy;

import com.alibaba.nacos.common.utils.MapUtils;
import com.jugg.agile.framework.core.config.JaCenterPropertyHandler;
import com.jugg.agile.framework.core.config.JaProperty;
import com.jugg.agile.framework.core.util.JaStringUtil;
import com.jugg.agile.middleware.nacos.config.JaNacosConfigPropertiesProcessor;
import com.jugg.agile.middleware.nacos.config.JaNacosConfigService;

import java.util.Map;

/**
 * 读取nacos rabbitmq.yaml中esp-proxy mq相关的公共配置
 */
public class DwEspProxyPostPropertyHandler implements JaCenterPropertyHandler {
    private static final String RABBIT_HOST = "spring.rabbit.host";

    private static final String RABBIT_PORT = "spring.rabbit.port";

    private static final String RABBIT_USERNAME = "spring.rabbit.username";

    private static final String RABBIT_PASSWORD = "spring.rabbit.password";

    private static final String RABBIT_VIRTUAL_HOST = "spring.rabbit.virtual-host";

    private static final String RABBIT_MQ_URI = "rabbit.mquri";

    @Override
    public void addAndCover() {
        addRabbitMQUri();
    }

    @Override
    public int order() {
        return 10;
    }

    private void addRabbitMQUri() {
        Map<String, Object> strObjMap = JaNacosConfigService.readYaml("rabbitmq.yml", JaNacosConfigPropertiesProcessor.getNameSpaceCommon());
        if (MapUtils.isEmpty(strObjMap)) {
            return;
        }

        if (!JaStringUtil.isObjEmpty(strObjMap.get(RABBIT_MQ_URI))) {
            JaProperty.getPropertyMap().put(RABBIT_MQ_URI, strObjMap.get(RABBIT_MQ_URI));
            return;
        }

        Object host = strObjMap.get(RABBIT_HOST);
        Object port = strObjMap.get(RABBIT_PORT);
        Object userName = strObjMap.get(RABBIT_USERNAME);
        Object password = strObjMap.get(RABBIT_PASSWORD);
        Object virtualHost = strObjMap.get(RABBIT_VIRTUAL_HOST);
        if (!JaStringUtil.isObjEmpty(host)
                && !JaStringUtil.isObjEmpty(port)
                && !JaStringUtil.isObjEmpty(userName)
                && !JaStringUtil.isObjEmpty(password)
                && !JaStringUtil.isObjEmpty(virtualHost)) {
            // 拼接 rabbit.mquri  "amqp://digiwin:digiwin@mq-paas.digiwincloud.com.cn:5677/athena"
            String rabbitMqUri = "amqp://" + userName.toString().trim()
                    + ":" + password.toString().trim()
                    + "@" + host.toString().trim()
                    + ":" + port.toString().trim()
                    + "/" + virtualHost.toString().trim();
            JaProperty.getPropertyMap().put(RABBIT_MQ_URI, rabbitMqUri);
        }
    }
}
