/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.athena.esp.proxy;

import com.alibaba.nacos.common.utils.MapUtils;
import com.jugg.agile.framework.core.config.JaCenterPropertyHandler;
import com.jugg.agile.framework.core.config.JaProperty;
import com.jugg.agile.framework.core.util.JaStringUtil;
import com.jugg.agile.middleware.nacos.config.JaNacosConfigPropertiesProcessor;
import com.jugg.agile.middleware.nacos.config.JaNacosConfigService;
import java.util.Map;

public class DwEspProxyPostPropertyHandler
implements JaCenterPropertyHandler {
    private static final String RABBIT_HOST = "spring.rabbit.host";
    private static final String RABBIT_PORT = "spring.rabbit.port";
    private static final String RABBIT_USERNAME = "spring.rabbit.username";
    private static final String RABBIT_PASSWORD = "spring.rabbit.password";
    private static final String RABBIT_VIRTUAL_HOST = "spring.rabbit.virtual-host";
    private static final String RABBIT_MQ_URI = "rabbit.mquri";

    public void addAndCover() {
        this.addRabbitMQUri();
    }

    public int order() {
        return 10;
    }

    private void addRabbitMQUri() {
        Map strObjMap = JaNacosConfigService.readYaml((String)"rabbitmq.yml", (String)JaNacosConfigPropertiesProcessor.getNameSpaceCommon());
        if (MapUtils.isEmpty((Map)strObjMap)) {
            return;
        }
        if (!JaStringUtil.isObjEmpty(strObjMap.get(RABBIT_MQ_URI))) {
            JaProperty.getPropertyMap().put(RABBIT_MQ_URI, strObjMap.get(RABBIT_MQ_URI));
            return;
        }
        Object host = strObjMap.get(RABBIT_HOST);
        Object port = strObjMap.get(RABBIT_PORT);
        Object userName = strObjMap.get(RABBIT_USERNAME);
        Object password = strObjMap.get(RABBIT_PASSWORD);
        Object virtualHost = strObjMap.get(RABBIT_VIRTUAL_HOST);
        if (!(JaStringUtil.isObjEmpty(host) || JaStringUtil.isObjEmpty(port) || JaStringUtil.isObjEmpty(userName) || JaStringUtil.isObjEmpty(password) || JaStringUtil.isObjEmpty(virtualHost))) {
            String rabbitMqUri = "amqp://" + userName.toString().trim() + ":" + password.toString().trim() + "@" + host.toString().trim() + ":" + port.toString().trim() + "/" + virtualHost.toString().trim();
            JaProperty.getPropertyMap().put(RABBIT_MQ_URI, rabbitMqUri);
        }
    }
}

