package com.digiwin.athena.abt.sdk.meta.dto.response;

import lombok.AllArgsConstructor;
import lombok.Getter;
import lombok.NoArgsConstructor;
import lombok.Setter;
import lombok.experimental.SuperBuilder;

import java.util.List;
import java.util.Map;

/**
 *  获取error table
 *
 * @author hbk
 * @since 2025/2/13
 */

@Setter
@Getter
@SuperBuilder
@AllArgsConstructor
@NoArgsConstructor
public class GetErrorTableRespDTO {

    private List<Map> data;
    private List<Map> headers;

    /**
     * action Id
     */
    private String actionId;

    /**
     * 成功数量
     */
    private Integer succeededNum;

    /**
     * 处理中数量
     */
    private Integer processingNum;

    /**
     * 失败数量
     */
    private Integer failedNum;

    /**
     * 错误数量
     */
    private Integer errorNum;

    /**
     * 是否可以重新导出 默认0
     */
    private Integer republished;

}
