package com.digiwin.athena.aee.python.sdk.manager;

import com.digiwin.athena.aee.python.sdk.meta.dto.AeePythonResultDTO;
import com.digiwin.athena.aee.python.sdk.meta.dto.request.StartAnalysisReqDTO;
import com.digiwin.athena.common.sdk.manager.meta.constants.DwHttpHeaderConstants;
import com.jugg.agile.framework.core.config.JaProperty;
import com.jugg.agile.framework.core.dapper.log.JaLog;
import com.jugg.agile.framework.core.util.io.net.http.JaHttpClient;
import com.jugg.agile.framework.core.util.io.net.http.JaHttpRequest;
import com.jugg.agile.framework.core.util.io.net.http.JaHttpResponse;
import com.jugg.agile.framework.core.util.io.serialize.json.JaJson;
import org.springframework.core.ParameterizedTypeReference;

import java.util.HashMap;
import java.util.Map;


/**
 * AI-python客户端 api
 *
 * @author yinhaiye
 * @since 2025/09/02 16:30
 */
public class AeePythonManager {

    private static String getAeeAUri() {
        return JaProperty.get("domain.aeea");
    }

    private static String getAeeAAppToken() {
        return JaProperty.get("app.token");
    }

    private static final ParameterizedTypeReference<AeePythonResultDTO<Object>> TRANSLATE_RESP_DTO_PARAMETERIZED_TYPE_REFERENCE = new ParameterizedTypeReference<AeePythonResultDTO<Object>>() {
    };

    /**
     * 发起根因分析接口
     */
    private static final String START_ROOT_CAUSE_ANALYSIS_API = getAeeAUri() + "/comprehensive_analysis";

    /**
     * 发调用大模型起根因分析
     * 大模型分析时间不可控，为了保证接口能正常响应，接口超时时间设置长一些，
     * 整体业务没有那么大的分析量，如果后续发现服务存在大量累积线程，再行优化
     * @param reqDTO  入参
     * @return AeePythonResultDTO<Object>
     */
    public static AeePythonResultDTO<Object> startRootCauseAnalysis(StartAnalysisReqDTO reqDTO) {
        if (null == reqDTO) {
            JaLog.error("startRootCauseAnalysis|发起根因分析入参为空");
            return null;
        }
        // 使用jdk调用方式，不放在环境变量里，防止被其他接口被覆盖
        JaProperty.put("ja.http.adapter", 2);
        Map<String, String> headers = new HashMap<>();
        headers.put(DwHttpHeaderConstants.Header_App_Token, getAeeAAppToken());
        // 调用大模型请求
        JaHttpResponse response = JaHttpClient.execute(JaHttpRequest.builder()
                .url(START_ROOT_CAUSE_ANALYSIS_API)
                .headers(headers)
                .body(JaJson.toString(reqDTO))
                // 超时时间设置2h
                .readTimeout(7200000)
                .build());
        return JaJson.toObject(response.getBody(), TRANSLATE_RESP_DTO_PARAMETERIZED_TYPE_REFERENCE.getType());
    }

    public static void main(String[] args) {
        JaProperty.put("ja.http.adapter", 2);
        Map<String, String> body = new HashMap<>();
        body.put("eocCompanyId", "aa");
        Map<String, String> headers = new HashMap<>();
        headers.put(DwHttpHeaderConstants.Header_App_Token, "aaa");
        // 调用大模型请求
        JaHttpResponse response = JaHttpClient.execute(JaHttpRequest.builder()
                .url("http://192.168.200.100:8088/aee/test/test1")
                .headers(headers)
                .body(JaJson.toString(body))
                .readTimeout(6000)
                .build());
        System.out.println("response:" + response.getBody());
    }
}
