package com.digiwin.athena.aee.python.sdk.meta.dto;

import com.jugg.agile.framework.meta.handler.JaResultParseHandler;
import lombok.AllArgsConstructor;
import lombok.Getter;
import lombok.NoArgsConstructor;
import lombok.Setter;
import lombok.experimental.SuperBuilder;

import java.io.Serializable;

/**
 * aee python组件返回的数据格式
 *
 * @author yinhaiye
 * @since 2025/9/02 15:28
 */
@Setter
@Getter
@SuperBuilder
@AllArgsConstructor
@NoArgsConstructor
public class AeePythonResultDTO<T> implements Serializable, JaResultParseHandler<T> {

    // 状态码
    private int code;
    // 返回值
    private T data;
    // 返回信息
    private String msg;

    @Override
    public Boolean success() {
        return this.code == 0;
    }

    @Override
    public String code() {
        return String.valueOf(this.code);
    }

    @Override
    public String message() {
        return this.msg;
    }

    @Override
    public T data() {
        return this.data;
    }
}
