package com.digiwin.athena.aee.python.sdk.meta.dto.request;

import lombok.AllArgsConstructor;
import lombok.Getter;
import lombok.NoArgsConstructor;
import lombok.Setter;
import lombok.experimental.SuperBuilder;

import java.io.Serializable;

/**
 * AI发起根因分析入参
 * @author yinhaiye
 * @since 2025/09/02 15:40
 */
@Setter
@Getter
@SuperBuilder
@AllArgsConstructor
@NoArgsConstructor
public class StartAnalysisReqDTO implements Serializable {

    /**
     * 报告code
     */
    private String code;

    /**
     * 生成报告时当前用户选择的语言别
     */
    private String langType;

    /**
     * 租户
     */
    private String tenant_id;

    /**
     * 公司别
     */
    private String eoc_company_id;

    /**
     * 默认传true
     */
    private Boolean forceAnalysis;

    /**
     * 议题名称
     */
    private String topic;

    /**
     * 指标树根节点
     */
    private String root;

    /**
     * 开始分析时间
     */
    private String start_time;

    /**
     * 结束分析时间
     */
    private String end_time;

    /**
     * model_type
     */
    private String model_type;

    /**
     * 当前时间戳
     */
    private String current_time;

    /**
     * 应用
     */
    private String application;

    /**
     * 分析类型 GLOBAL_ANALYSIS：全局分析 LOCAL_ANALYSIS：局部分析 DIMENSION_ANALYSIS：维度分析
     * 默认全局分析
     */
    private String analysisType;

    /**
     * 维度分析时需要传入的指标code
     */
    private String dimensionIndicatorCode;
}
