package com.digiwin.athena.aim.sdk.meta.dto.request;

import com.alibaba.fastjson.JSONObject;
import com.digiwin.athena.aim.sdk.meta.dto.BaseEntity;
import lombok.*;
import lombok.experimental.Accessors;
import lombok.experimental.SuperBuilder;

import java.time.LocalDateTime;

@Setter
@Getter
@SuperBuilder
@NoArgsConstructor
@AllArgsConstructor
@Builder
@Accessors(chain = true)
public class ActivityReqDTO extends BaseEntity {

    private Long id;

    private String name;

    private Long bpmProcessId;

    private Long taskId;

    private Long activityDefineId;

    /**
     * 计划开始时间
     */
    private LocalDateTime startTime;

    /**
     * 计划结束时间
     */
    private LocalDateTime endTime;

    private LocalDateTime actualStartTime;

    private LocalDateTime actualEndTime;

    private Boolean exception;

    private Integer state;


    private ActivityStateReqDTO activityState;

    /**
     * bpm推送的关卡数据
     */
    private JSONObject data;
}