package com.digiwin.athena.aim.sdk.manager;

import com.digiwin.athena.aim.sdk.meta.dto.AimResultDTO;
import com.digiwin.athena.aim.sdk.meta.dto.request.AppMessageReqDTO;
import com.digiwin.athena.aim.sdk.meta.dto.request.message.MessageBatchUserDTO;
import com.digiwin.athena.aim.sdk.meta.dto.request.message.MessageDTO;
import com.digiwin.athena.appcore.auth.domain.AuthoredUser;
import com.digiwin.athena.common.sdk.manager.meta.constants.DwHttpHeaderConstants;
import com.digiwin.athena.common.sdk.manager.util.DwSpringHttpUtil;
import com.jugg.agile.framework.core.config.JaProperty;
import org.springframework.core.ParameterizedTypeReference;

/**
 * aim 相关接口
 *
 * @author gengwei
 * @since 2024/9/2 16:52
 */
public class AimManager {

    private static String getAimUri() {
        return JaProperty.get("aim.uri");
    }

    private static final ParameterizedTypeReference<AimResultDTO<Object>> ObjectType = new ParameterizedTypeReference<AimResultDTO<Object>>() {
    };

    /**
     * 存储新消息
     */
    public static final String Url_message= getAimUri() + "/api/aim/v1/message";

    public static AimResultDTO<Object> message(AuthoredUser authoredUser, MessageDTO message) {
        return DwSpringHttpUtil.post(Url_message, message, ObjectType, headers -> headers.add(DwHttpHeaderConstants.Header_User_Token, authoredUser.getToken()));
    }


    /**
     * 发送消息提醒
     */
    public static final String Url_sendMsgRemindToClient = getAimUri() + "/api/aim/v2/send/message/remind/to/client";

    public static AimResultDTO<Object> sendMsgRemindToClient(String token, AppMessageReqDTO appMessageDTO) {
        return DwSpringHttpUtil.post(Url_sendMsgRemindToClient, appMessageDTO, ObjectType, headers -> headers.add(DwHttpHeaderConstants.Header_User_Token, token));

    }

    /**
     * 发送消息给在线客户端
     */
    public static final String Url_sendMessageToClient = getAimUri() + "/api/aim/v2/send/message/to/client";

    public static AimResultDTO<Object> sendMessageToClient(String token, MessageBatchUserDTO messageBatchUserDTO) {
        return DwSpringHttpUtil.post(Url_sendMessageToClient, messageBatchUserDTO, ObjectType, headers -> headers.add(DwHttpHeaderConstants.Header_User_Token, token));

    }

}
