/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.athena.aim.sdk.manager;

import com.digiwin.athena.aim.sdk.meta.dto.AimResultDTO;
import com.digiwin.athena.aim.sdk.meta.dto.request.AppMessageReqDTO;
import com.digiwin.athena.aim.sdk.meta.dto.request.message.MessageBatchUserDTO;
import com.digiwin.athena.aim.sdk.meta.dto.request.message.MessageCenterSendDTO;
import com.digiwin.athena.aim.sdk.meta.dto.request.message.MessageDTO;
import com.digiwin.athena.aim.sdk.meta.dto.response.GrayTenantDTO;
import com.digiwin.athena.appcore.auth.domain.AuthoredUser;
import com.digiwin.athena.common.sdk.manager.meta.dto.BaseResultDTO;
import com.digiwin.athena.common.sdk.manager.util.DwSpringHttpUtil;
import com.jugg.agile.framework.core.config.JaProperty;
import com.jugg.agile.framework.core.util.JaStringUtil;
import java.util.Collections;
import java.util.List;
import org.springframework.core.ParameterizedTypeReference;
import org.springframework.util.StringUtils;
import org.springframework.web.util.UriComponentsBuilder;

public class AimManager {
    private static final ParameterizedTypeReference<AimResultDTO<Object>> ObjectType = new ParameterizedTypeReference<AimResultDTO<Object>>(){};
    private static final ParameterizedTypeReference<AimResultDTO<List<String>>> WithPreTenantDTOType = new ParameterizedTypeReference<AimResultDTO<List<String>>>(){};
    private static final ParameterizedTypeReference<AimResultDTO<GrayTenantDTO>> WithResolveTenantDTOType = new ParameterizedTypeReference<AimResultDTO<GrayTenantDTO>>(){};
    public static final String Url_message = AimManager.getAimUri() + "/api/aim/v1/message";
    public static final String Url_sendMsgRemindToClient = AimManager.getAimUri() + "/api/aim/v2/send/message/remind/to/client";
    public static final String Url_sendMessageToClient = AimManager.getAimUri() + "/api/aim/v2/send/message/to/client";
    public static final String PRE_ENV_TENANTLDLIST_URL = AimManager.getAimUri() + "/api/aim/v1/tenant/route/queryPreEnvTenantIdList";
    public static final String PRE_ENV_RESOLVE_TENANTLDLIST_URL = AimManager.getAimUri() + "/api/aim/v1/tenant/route/queryResolveEnvTenantIdList";
    public static final String URL_MESSAGE_CENTER_SEND = AimManager.getAimUri() + "/api/aim/message/center/send";
    private static final ParameterizedTypeReference<BaseResultDTO<Object>> baseResultDTOType = new ParameterizedTypeReference<BaseResultDTO<Object>>(){};

    private static String getAimUri() {
        return JaProperty.get((String)"aim.uri");
    }

    public static AimResultDTO<Object> message(AuthoredUser authoredUser, MessageDTO message) {
        return (AimResultDTO)((Object)DwSpringHttpUtil.post((String)Url_message, (Object)message, ObjectType, headers -> headers.add("digi-middleware-auth-user", authoredUser.getToken())));
    }

    public static AimResultDTO<Object> sendMsgRemindToClient(String token, AppMessageReqDTO appMessageDTO) {
        return (AimResultDTO)((Object)DwSpringHttpUtil.post((String)Url_sendMsgRemindToClient, (Object)appMessageDTO, ObjectType, headers -> headers.add("digi-middleware-auth-user", token)));
    }

    public static AimResultDTO<Object> sendMessageToClient(String token, MessageBatchUserDTO messageBatchUserDTO) {
        return (AimResultDTO)((Object)DwSpringHttpUtil.post((String)Url_sendMessageToClient, (Object)messageBatchUserDTO, ObjectType, headers -> headers.add("digi-middleware-auth-user", token)));
    }

    public static AimResultDTO<List<String>> queryPreEnvTenantldList(String appCode) {
        String url = UriComponentsBuilder.fromHttpUrl((String)PRE_ENV_TENANTLDLIST_URL).queryParam("app", new Object[]{appCode}).build().encode().toUriString();
        return (AimResultDTO)((Object)DwSpringHttpUtil.get((String)url, WithPreTenantDTOType, httpHeaders -> {
            String tenantIds = JaProperty.get((String)"athena.export.grayTenants");
            tenantIds = JaStringUtil.isEmpty((String)tenantIds) ? "99990000" : tenantIds;
            String[] tenantIdArray = StringUtils.split((String)tenantIds, (String)",");
            String tenantId = tenantIdArray != null && tenantIdArray.length > 0 ? tenantIdArray[0] : "99990000";
            httpHeaders.set("routerkey", tenantId);
            httpHeaders.set("token", "e6cf01a1-18b1-45e4-ba2b-6ccdb35c49b9");
        }, Collections.emptyMap()));
    }

    public static AimResultDTO<GrayTenantDTO> queryResolveEnvTenantIdList(String appCode, String mode) {
        String url = UriComponentsBuilder.fromHttpUrl((String)PRE_ENV_RESOLVE_TENANTLDLIST_URL).queryParam("app", new Object[]{appCode}).queryParam("mode", new Object[]{mode}).build().encode().toUriString();
        return (AimResultDTO)((Object)DwSpringHttpUtil.get((String)url, WithResolveTenantDTOType, httpHeaders -> httpHeaders.set("token", "e6cf01a1-18b1-45e4-ba2b-6ccdb35c49b9"), Collections.emptyMap()));
    }

    public static BaseResultDTO<Object> messageCenterSend(MessageCenterSendDTO message) {
        return (BaseResultDTO)DwSpringHttpUtil.post((String)URL_MESSAGE_CENTER_SEND, (Object)message, baseResultDTOType);
    }
}

