package com.digiwin.athena.aim.sdk.meta.dto.request;

import com.fasterxml.jackson.annotation.JsonValue;

public enum ActivityStateReqDTO {
    //-1=預測關卡（核决层级需要的关卡）
    //0 未开始，未知状态
    //進行中1 暫停2 順利完成的3 撤銷4 關閉5

    /**
     * ATMC自定义状态，可视化面板多个任务，表示有的已完成，有的未开始
     */
    MIXED(-9001),

    /**
     * ATMC自定义状态，可视化面板某个任务，因为项目已经关闭，而跳过该任务，表示该任务不可点击
     */
    SKIPFORFINISHED(-9002),

    /**
     * -1.预测关卡，将来有可能有，有可能没有
     */
    FORECAST(-1),

    /**
     * 0.未知状态，ATMC中虚拟关卡专用
     */
    UNKNOWN(0),

    /**
     * 1.关卡正在执行（进行）中
     */
    EXECUTEING(1),

    /**
     * 2.关卡暂停
     */
    PAUSE(2),

    /**
     * 3.关卡顺利完成
     */
    COMPLETED(3),

    /**
     * 4.撤銷
     */
    UNDO(4),

    /**
     * 5.已中止
     */
    CLOSED(5),

    /**
     * 6.進行中但已開始執行
     */
    PARTCOMPLETED(6);

    @JsonValue    //标记响应json值
    private int code;

    public int getCode() {
        return code;
    }

    ActivityStateReqDTO(int code) {
        this.code = code;
    }

    public static ActivityStateReqDTO fromInt(int code) {
        switch (code) {
            case -1:
                return FORECAST;
            case 0:
                return UNKNOWN;
            case 1:
                return EXECUTEING;
            case 2:
                return PAUSE;
            case 3:
                return COMPLETED;
            case 4:
                return UNDO;
            case 5:
                return CLOSED;
            case 6:
                return PARTCOMPLETED;
            default:
                return null;
        }
    }

    public Integer getValue() {
        return code;
    }
}