package com.digiwin.athena.aim.sdk.meta.dto.request;

import com.digiwin.athena.aim.sdk.meta.dto.BaseEntity;
import lombok.*;
import lombok.experimental.Accessors;
import lombok.experimental.SuperBuilder;

import java.time.LocalDateTime;

@Setter
@Getter
@SuperBuilder
@NoArgsConstructor
@AllArgsConstructor
@Builder
@Accessors(chain = true)
public class BacklogReqDTO extends BaseEntity {
    private Long id;

    private String name;

    private Long taskId;

    private Long activityId;

    private String performerId;
    private String tenantId;
    private String content;

    /**
     * 格式："{"zh_CN":"xxx", "zh_TW": "xxxxx", "en_US": "xxxxxx"}"
     */
    private String withName;
    /**
     * 格式："{"zh_CN":"xxx", "zh_TW": "xxxxx", "en_US": "xxxxxx"}"
     */
    private String contentWithName;
    private String uri;
    private LocalDateTime startTime;
    private LocalDateTime endTime;
    private Boolean closed;
    /**
     * 2021-10-18，zhujg
     * 已停用，请使有用 BpmActivityWorkitem.importance
     */
    private Integer importance;
    /**
     * 2021-10-18，zhujg
     * 已停用，请使有用 BpmActivityWorkitem.importance
     */
    private String importanceSource;
    private Integer type = 1;
    private Long bpmActivityId;
    /**
     * 已读次数
     */
    private Integer readCount = 0;

    /**
     * 执行者姓名
     */
    private String performerName;

    private Long bpmActivityStepId;

    private LocalDateTime createTime;

    /**
     * 转派的来源backlog.id
     * -- 已废弃--
     */
    private Long reassignFromId = 0L;

    /**
     * 签核状态，BPM签核状态,空-无状态，reassign-转派,reexecute-退回
     * -- 2021-08-06 迭代18，zhujg,废弃，使用 bpm_activity_workitem.approval_state
     */
    @Deprecated
    private String approvalState = "";

    /**
     * 缓存任务的summaryLayout
     */
    private String taskSummaryLayout;

    /**
     * 缓存项目的summaryLayout
     */
    private String projectSummaryLayout;

    /**
     * 原逾期的backlog.Id
     */
    private Long overdueBacklogId = 0L;

    /**
     * 来源租户
     */
    private String sourceTenantId;

    /**
     * 来源租户名称
     */
    private String sourceTenantName;
    /**
     * 实际处理人
     */
    private String executor;

    /**
     * 是否是外部任务 （0 - 否，1- 是）
     */
    private Integer isExternal;

    /**
     * 引擎类型
     * FlowEngine BP
     * TaskEngine 任务引擎
     */
    private String engineType;


    private String activityCode;


    private Long projectId;

}