/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.athena.atdm.sdk.manager;

import com.digiwin.athena.atdm.sdk.meta.dto.AtdmResultDTO;
import com.digiwin.athena.atdm.sdk.meta.dto.request.action.QueryBacklogWithMetadataReqDTO;
import com.digiwin.athena.atdm.sdk.meta.dto.request.action.SubmitActionReqDTO;
import com.digiwin.athena.atdm.sdk.meta.dto.response.ExecuteResultRespDTO;
import com.digiwin.athena.atdm.sdk.meta.dto.response.GetErrorTableRespDTO;
import com.digiwin.athena.atdm.sdk.meta.dto.response.QueryResultSetRespDTO;
import com.digiwin.athena.common.sdk.manager.util.DwSpringHttpUtil;
import com.jugg.agile.framework.core.config.JaProperty;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.springframework.core.ParameterizedTypeReference;

public class AtdmManager {
    private static final ParameterizedTypeReference<AtdmResultDTO<ExecuteResultRespDTO>> ExecuteResultType = new ParameterizedTypeReference<AtdmResultDTO<ExecuteResultRespDTO>>(){};
    private static final ParameterizedTypeReference<AtdmResultDTO<List<Map<Object, Object>>>> ListMapType = new ParameterizedTypeReference<AtdmResultDTO<List<Map<Object, Object>>>>(){};
    private static final ParameterizedTypeReference<AtdmResultDTO<Map<Object, Object>>> MapType = new ParameterizedTypeReference<AtdmResultDTO<Map<Object, Object>>>(){};
    private static final ParameterizedTypeReference<AtdmResultDTO<Object>> ObjectType = new ParameterizedTypeReference<AtdmResultDTO<Object>>(){};
    private static final ParameterizedTypeReference<AtdmResultDTO<QueryResultSetRespDTO>> QueryResultSetType = new ParameterizedTypeReference<AtdmResultDTO<QueryResultSetRespDTO>>(){};
    private static final ParameterizedTypeReference<AtdmResultDTO<GetErrorTableRespDTO>> ErrorTableType = new ParameterizedTypeReference<AtdmResultDTO<GetErrorTableRespDTO>>(){};
    public static final String ACTION_EXECUTE_URL = AtdmManager.getAtdmUri() + "api/atdm/v1/action/execute";
    public static final String ACTION_SUBMIT_MERGE_TASK_URL = AtdmManager.getAtdmUri() + "api/atdm/v1/action/submit/mergeTask";
    public static final String ACTION_SUBMIT_TASK_URL = AtdmManager.getAtdmUri() + "api/atdm/v1/action/submit/task";
    public static final String CACHE_RESET_URL = "api/atdm/v1/cache/reset?size={size}";
    public static final String WITH_META_DATA_URL = AtdmManager.getAtdmUri() + "api/atdm/v1/data/query/by/backlog/withmetadata";
    public static final String GET_ERROR_TABLE = AtdmManager.getAtdmUri() + "baseDataEntry/getErrorTable/{masterId}";

    private static String getAtdmUri() {
        return JaProperty.get((String)"atdm.uri");
    }

    public static AtdmResultDTO<ExecuteResultRespDTO> executeTask(SubmitActionReqDTO submitAction) {
        return (AtdmResultDTO)((Object)DwSpringHttpUtil.post((String)ACTION_EXECUTE_URL, (Object)submitAction, ExecuteResultType));
    }

    public static AtdmResultDTO<List<Map<Object, Object>>> submitMergeTask(List<SubmitActionReqDTO> mergeActionList) {
        return (AtdmResultDTO)((Object)DwSpringHttpUtil.post((String)ACTION_SUBMIT_MERGE_TASK_URL, mergeActionList, ListMapType));
    }

    public static AtdmResultDTO<Map<Object, Object>> submitTask(SubmitActionReqDTO submitAction) {
        return (AtdmResultDTO)((Object)DwSpringHttpUtil.post((String)ACTION_SUBMIT_TASK_URL, (Object)submitAction, MapType));
    }

    public static void clearCache(Integer size) {
        HashMap<String, Integer> param = new HashMap<String, Integer>();
        param.put("size", size);
        DwSpringHttpUtil.get((String)CACHE_RESET_URL, ObjectType, param);
    }

    public static AtdmResultDTO<QueryResultSetRespDTO> queryBacklogWithMetadata(QueryBacklogWithMetadataReqDTO queryBacklogWithMetadataReqDTO) {
        return (AtdmResultDTO)((Object)DwSpringHttpUtil.post((String)WITH_META_DATA_URL, (Object)queryBacklogWithMetadataReqDTO, QueryResultSetType));
    }

    public static AtdmResultDTO<GetErrorTableRespDTO> getErrorTable(String masterId) {
        HashMap<String, String> param = new HashMap<String, String>();
        param.put("masterId", masterId);
        return (AtdmResultDTO)((Object)DwSpringHttpUtil.get((String)GET_ERROR_TABLE, ErrorTableType, param));
    }
}

