/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.athena.atmc.sdk.manager;

import com.digiwin.athena.atmc.sdk.meta.dto.AtmcResultDTO;
import com.digiwin.athena.atmc.sdk.meta.dto.request.PanelInfoReqDTO;
import com.digiwin.athena.atmc.sdk.meta.dto.request.SubProjectReqDTO;
import com.digiwin.athena.atmc.sdk.meta.dto.response.SubProjectRespDTO;
import com.digiwin.athena.atmc.sdk.meta.dto.response.TaskDataSourcesRespDTO;
import com.digiwin.athena.atmc.sdk.meta.dto.response.TaskPanelV2RespDTO;
import com.digiwin.athena.common.sdk.manager.util.DwSpringHttpUtil;
import com.jugg.agile.framework.core.config.JaProperty;
import java.util.List;
import org.springframework.core.ParameterizedTypeReference;
import org.springframework.util.StringUtils;
import org.springframework.web.util.UriComponentsBuilder;

public class AtmcManager {
    private static final ParameterizedTypeReference<AtmcResultDTO<TaskPanelV2RespDTO>> PanelInfoResultType = new ParameterizedTypeReference<AtmcResultDTO<TaskPanelV2RespDTO>>(){};
    private static final ParameterizedTypeReference<AtmcResultDTO<TaskDataSourcesRespDTO>> GetSourcesByMainTaskIdV2ResultType = new ParameterizedTypeReference<AtmcResultDTO<TaskDataSourcesRespDTO>>(){};
    private static final ParameterizedTypeReference<AtmcResultDTO<List<SubProjectRespDTO>>> GetSubProjectResultType = new ParameterizedTypeReference<AtmcResultDTO<List<SubProjectRespDTO>>>(){};
    public static final String ATMC_GET_PANELINFO = AtmcManager.getPrefixUri() + "/api/atmc/v1/task/panel/taskEnginePanelInfo";
    public static final String ATMC_GET_TASK_SOURCES = AtmcManager.getPrefixUri() + "/api/atmc/v2/task/panel/getSourcesByMainTaskId";
    public static final String ATMC_GET_SUBPROJECT = AtmcManager.getPrefixUri() + "/api/atmc/v2/project/subproject";

    private static String getPrefixUri() {
        return JaProperty.get((String)"atmc.uri");
    }

    public static AtmcResultDTO<TaskPanelV2RespDTO> panelInfo(PanelInfoReqDTO requestDTO) {
        UriComponentsBuilder uriComponentsBuilder = UriComponentsBuilder.fromHttpUrl((String)ATMC_GET_PANELINFO).queryParam("taskId", new Object[]{requestDTO.getTaskId()}).queryParam("reqPtm", new Object[]{true});
        if (!StringUtils.isEmpty((Object)requestDTO.getShareCode())) {
            uriComponentsBuilder.queryParam("shareCode", new Object[]{requestDTO.getShareCode()});
        }
        if (requestDTO.isShare()) {
            uriComponentsBuilder.queryParam("isShare", new Object[]{true});
        }
        return (AtmcResultDTO)((Object)DwSpringHttpUtil.get((String)uriComponentsBuilder.build().toUriString(), PanelInfoResultType));
    }

    public static AtmcResultDTO<TaskDataSourcesRespDTO> getSourcesByMainTaskIdV2(SubProjectReqDTO subProjectReqDTO) {
        return (AtmcResultDTO)((Object)DwSpringHttpUtil.post((String)ATMC_GET_TASK_SOURCES, (Object)subProjectReqDTO, GetSourcesByMainTaskIdV2ResultType));
    }

    public static AtmcResultDTO<List<SubProjectRespDTO>> getSubProject(SubProjectReqDTO requestDTO) {
        return (AtmcResultDTO)((Object)DwSpringHttpUtil.post((String)ATMC_GET_SUBPROJECT, (Object)requestDTO, GetSubProjectResultType));
    }
}

