package com.digiwin.athena.atmc.sdk.meta.dto.response;

import com.alibaba.fastjson.JSONObject;
import lombok.AllArgsConstructor;
import lombok.Getter;
import lombok.NoArgsConstructor;
import lombok.Setter;

import java.time.LocalDateTime;

@Getter
@Setter
@AllArgsConstructor
@NoArgsConstructor
public class TaskPanelActivityRespDTO {
    private String id;
    private String name;
    private String subName;

    private Integer sequence;
    private Integer state;
    private Integer importance;
    private Boolean exception;
    /**
     * 任务是否异常
     */
    private Boolean hasException;
    private LocalDateTime startTime;
    private LocalDateTime planEndTime;
    private Boolean executeType;
    private Integer totalCount;
    private Integer finishedCount;
    private Boolean actionDefined;
    private String tmCategory;
    private String tmPattern;
    private Boolean tmMilestone;
    private Long activityId;


    /**
     * 是否逾期
     */
    private Boolean overdue;

    /**
     * 变更信息
     */
    private JSONObject changedProject;

    /**
     * 实际完成时间
     */
    private LocalDateTime actualEndTime;

    /**
     * 包含逾期完成的任务数量
     */
    private Integer overdueFinishedCount;
}
