package com.digiwin.athena.atmc.sdk.meta.dto;

import com.digiwin.athena.common.sdk.manager.meta.dto.BaseResultDTO;
import com.jugg.agile.framework.core.util.JaStringUtil;
import com.jugg.agile.framework.meta.handler.JaResultParseHandler;
import lombok.AllArgsConstructor;
import lombok.Getter;
import lombok.NoArgsConstructor;
import lombok.Setter;
import lombok.experimental.SuperBuilder;

@Setter
@Getter
@SuperBuilder
@AllArgsConstructor
@NoArgsConstructor
public class AtmcResultDTO<T> extends BaseResultDTO<T> implements JaResultParseHandler<T> {
    private String code;
    private Long serverTime;
    private String path;
    private String traceId;
    private String description;


    @Override
    public Boolean success() {
        if (JaStringUtil.isNotEmpty(this.getErrorCode())) {
            return false;
        } else {
            return null != this.getStatus() && 200 == this.getStatus();
        }
    }

    @Override
    public String code() {
        return code;
    }

    @Override
    public String message() {
        return getErrorMessage();
    }

    @Override
    public T data() {
        return getResponse();
    }
}
