package com.digiwin.athena.aim.sdk.manager;

import com.digiwin.athena.aim.sdk.meta.dto.request.AccessibleReqDTO;
import com.digiwin.athena.aim.sdk.meta.dto.response.AccessibleRespDTO;
import com.digiwin.athena.aim.sdk.meta.dto.response.AudcResultDTO;
import com.digiwin.athena.common.sdk.manager.util.DwSpringHttpUtil;
import com.jugg.agile.framework.core.config.JaProperty;
import org.springframework.core.ParameterizedTypeReference;

import java.util.List;

/**
 *
 * audc api
 *
 * @author hbk
 * @since 2025/2/13
 */
public class AudcManager {

    private static String getAudcUri() {
        return JaProperty.get("audc.uri");
    }


    private static final ParameterizedTypeReference<AudcResultDTO<List<AccessibleRespDTO>>> ExecuteResultType = new ParameterizedTypeReference<AudcResultDTO<List<AccessibleRespDTO>>>() {
    };


    /**
     * 校验作业权限
     */
    public static final String CHECK_ACTIVITIES_ACCESSIBLE = getAudcUri() + "/api/audc/v1/check/activity/accessible";


    /**
     * 校验作业权限
     * @param reqDTOS
     * @return
     */
    public static AudcResultDTO<List<AccessibleRespDTO>> checkAccessible (List<AccessibleReqDTO> reqDTOS) {
        return DwSpringHttpUtil.post(CHECK_ACTIVITIES_ACCESSIBLE, reqDTOS, ExecuteResultType);
    }

}
