package com.digiwin.athena.aim.sdk.meta.dto.request;

import lombok.AllArgsConstructor;
import lombok.Getter;
import lombok.NoArgsConstructor;
import lombok.Setter;
import lombok.experimental.SuperBuilder;

import java.util.List;


@Setter
@Getter
@SuperBuilder
@AllArgsConstructor
@NoArgsConstructor
public class AccessibleReqDTO {

    // 任务
    public static final Integer CATEGORY_TASK = 1;

    // 项目
    public static final Integer CATEGORY_PROJECT = 2;

    /**
     * 作业类别，任务：1 （默认），2（项目）
     */
    private Integer category;

    /**
     * 作业类型
     */
    private String type;

    /**
     * 要校验的权限列表
     */
    private List<String> permissionCheckList;

    /**
     * ThemeMap定义的活动id
     */
    private List<String> tmActivityIdList;
}
