package com.digiwin.athena.cac.sdk.manager;

import com.digiwin.athena.appcore.auth.AppAuthContextHolder;
import com.digiwin.athena.appcore.auth.domain.AuthoredUser;
import com.digiwin.athena.cac.sdk.meta.dto.CacResultDTO;
import com.digiwin.athena.cac.sdk.meta.dto.response.AppAuthDTO;
import com.digiwin.athena.cac.sdk.meta.dto.response.UserAppDTO;
import com.digiwin.athena.common.sdk.manager.meta.constants.DwHttpHeaderConstants;
import com.digiwin.athena.common.sdk.manager.util.DwHttpResultParseUtil;
import com.digiwin.athena.common.sdk.manager.util.DwSpringHttpUtil;
import com.jugg.agile.framework.core.config.JaProperty;
import org.springframework.core.ParameterizedTypeReference;

import java.util.HashMap;
import java.util.List;
import java.util.Map;

/**
 * cam 相关接口
 *
 * @author gengwei
 * @since 2024/8/15 11:18
 */
public class CacManager {

    private static String getIamAppToken() {
        return JaProperty.get("iam.appToken");
    }

    private static String getCacUri() {
        return JaProperty.get("iam.cacUri");
    }

    public static final ParameterizedTypeReference<CacResultDTO<List<UserAppDTO>>> UserAppDTOListType = new ParameterizedTypeReference<CacResultDTO<List<UserAppDTO>>>() {
    };
    public static final ParameterizedTypeReference<AppAuthDTO> AppAuthDTOType = new ParameterizedTypeReference<AppAuthDTO>() {
    };
    public static final ParameterizedTypeReference<List<String>> ListStringType = new ParameterizedTypeReference<List<String>>() {
    };

    public static String qryUserAppByUserIdUrl = getCacUri() + "/api/cac/v4/authorizations/current/user/apps?userId={userId}";

    public static CacResultDTO<List<UserAppDTO>> qryUserAppByUserId(String userId) {
        // url 中参数
        Map<String, Object> param = new HashMap<>(1);
        param.put("userId", userId);
        return DwSpringHttpUtil.get(qryUserAppByUserIdUrl, UserAppDTOListType, param);
    }

    /**
     * 查询当前登录用户所有的应用权限
     */
    public static final String AUTHORIZATIONS_CURRENT_USER_APPS_URL = getCacUri() + "/api/cac/v4/authorizations/current/user/apps";

    public static CacResultDTO<List<UserAppDTO>> qryUserApp() {
        return DwSpringHttpUtil.get(AUTHORIZATIONS_CURRENT_USER_APPS_URL, UserAppDTOListType);
    }

    /**
     * 查询当前登录用户所有的应用权限
     * @return List<UserAppDTO>
     */
    public static List<UserAppDTO> queryUserAllApp() {
        AuthoredUser authoredUser = AppAuthContextHolder.getContext().getAuthoredUser();
        return DwHttpResultParseUtil.parse(DwSpringHttpUtil.get(AUTHORIZATIONS_CURRENT_USER_APPS_URL, UserAppDTOListType, httpHeaders -> httpHeaders.set(DwHttpHeaderConstants.Header_User_Token, authoredUser.getToken()), new HashMap<>()));
    }

    /**
     * 检查指定用户的指定应用 在当前租户是否有授权
     */
    public static final String AUTHORIZATIONS_CURRENT_TENANT_USERS_USER_ID_GOODS_APP_CODE_BY_USER_URL = getCacUri() + "/api/cac/v4/authorizations/currentTenant/users/{userId}/goods/{appCode}/byUser";

    /**
     * 检查指定用户的指定应用 在当前租户是否有授权
     *
     * @param userId
     * @param appCode
     * @return
     */
    public static AppAuthDTO queryAppAuth(String userId, String appCode) {

        Map<String, Object> param = new HashMap<>();
        param.put("userId", userId);
        param.put("appCode", appCode);
        return DwSpringHttpUtil.get(AUTHORIZATIONS_CURRENT_TENANT_USERS_USER_ID_GOODS_APP_CODE_BY_USER_URL, AppAuthDTOType, param);

    }

    /**
     * 查询应用Code 下授权的人员
     */
    public static final String COUNTING_CURRENT_TENANT_GOODS_GOODS_CODE_URL = getCacUri() + "/api/cac/v4/counting/currenttenant/goods/{goodsCode}";

    public static List<String> queryUserByAppCode(String appCode) {
        Map<String, String> param = new HashMap<>();
        param.put("goodsCode", appCode);
        return DwSpringHttpUtil.get(COUNTING_CURRENT_TENANT_GOODS_GOODS_CODE_URL, ListStringType, param);
    }


}
