/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.athena.cac.sdk.manager;

import com.digiwin.athena.appcore.auth.AppAuthContextHolder;
import com.digiwin.athena.appcore.auth.domain.AuthoredUser;
import com.digiwin.athena.cac.sdk.meta.dto.CacResultDTO;
import com.digiwin.athena.cac.sdk.meta.dto.response.AppAuthDTO;
import com.digiwin.athena.cac.sdk.meta.dto.response.UserAppDTO;
import com.digiwin.athena.common.sdk.manager.util.DwHttpResultParseUtil;
import com.digiwin.athena.common.sdk.manager.util.DwSpringHttpUtil;
import com.jugg.agile.framework.core.config.JaProperty;
import com.jugg.agile.framework.meta.handler.JaResultParseHandler;
import java.util.HashMap;
import java.util.List;
import org.springframework.core.ParameterizedTypeReference;

public class CacManager {
    public static final ParameterizedTypeReference<CacResultDTO<List<UserAppDTO>>> UserAppDTOListType = new ParameterizedTypeReference<CacResultDTO<List<UserAppDTO>>>(){};
    public static final ParameterizedTypeReference<AppAuthDTO> AppAuthDTOType = new ParameterizedTypeReference<AppAuthDTO>(){};
    public static final ParameterizedTypeReference<List<String>> ListStringType = new ParameterizedTypeReference<List<String>>(){};
    public static String qryUserAppByUserIdUrl = CacManager.getCacUri() + "/api/cac/v4/authorizations/current/user/apps?userId={userId}";
    public static final String AUTHORIZATIONS_CURRENT_USER_APPS_URL = CacManager.getCacUri() + "/api/cac/v4/authorizations/current/user/apps";
    public static final String AUTHORIZATIONS_CURRENT_TENANT_USERS_USER_ID_GOODS_APP_CODE_BY_USER_URL = CacManager.getCacUri() + "/api/cac/v4/authorizations/currentTenant/users/{userId}/goods/{appCode}/byUser";
    public static final String COUNTING_CURRENT_TENANT_GOODS_GOODS_CODE_URL = CacManager.getCacUri() + "/api/cac/v4/counting/currenttenant/goods/{goodsCode}";

    private static String getCacUri() {
        return JaProperty.get((String)"iam.cacUri");
    }

    public static CacResultDTO<List<UserAppDTO>> qryUserAppByUserId(String userId) {
        HashMap<String, String> param = new HashMap<String, String>(1);
        param.put("userId", userId);
        return (CacResultDTO)DwSpringHttpUtil.get((String)qryUserAppByUserIdUrl, UserAppDTOListType, param);
    }

    public static CacResultDTO<List<UserAppDTO>> qryUserApp() {
        return (CacResultDTO)DwSpringHttpUtil.get((String)AUTHORIZATIONS_CURRENT_USER_APPS_URL, UserAppDTOListType);
    }

    public static List<UserAppDTO> queryUserAllApp() {
        AuthoredUser authoredUser = AppAuthContextHolder.getContext().getAuthoredUser();
        return (List)DwHttpResultParseUtil.parse((JaResultParseHandler)((JaResultParseHandler)DwSpringHttpUtil.get((String)AUTHORIZATIONS_CURRENT_USER_APPS_URL, UserAppDTOListType, httpHeaders -> httpHeaders.set("digi-middleware-auth-user", authoredUser.getToken()), new HashMap())));
    }

    public static AppAuthDTO queryAppAuth(String userId, String appCode) {
        HashMap<String, String> param = new HashMap<String, String>();
        param.put("userId", userId);
        param.put("appCode", appCode);
        return (AppAuthDTO)DwSpringHttpUtil.get((String)AUTHORIZATIONS_CURRENT_TENANT_USERS_USER_ID_GOODS_APP_CODE_BY_USER_URL, AppAuthDTOType, param);
    }

    public static List<String> queryUserByAppCode(String appCode) {
        HashMap<String, String> param = new HashMap<String, String>();
        param.put("goodsCode", appCode);
        return (List)DwSpringHttpUtil.get((String)COUNTING_CURRENT_TENANT_GOODS_GOODS_CODE_URL, ListStringType, param);
    }
}

