package com.digiwin.athena.cam.sdk.manager;

import com.digiwin.athena.cam.sdk.meta.dto.CamResultDTO;
import com.digiwin.athena.cam.sdk.meta.dto.response.AppMappingsDTO;
import com.digiwin.athena.common.sdk.manager.meta.constants.DwHttpHeaderConstants;
import com.digiwin.athena.common.sdk.manager.util.DwSpringHttpUtil;
import com.jugg.agile.framework.core.config.JaProperty;
import org.springframework.core.ParameterizedTypeReference;

import java.util.Collections;
import java.util.List;

/**
 * Cam 相关接口
 *
 * @author gengwei
 * @since 2024/8/15 11:18
 */
public class CamManager {

    private static String getCamUri() {
        return JaProperty.get("cam.uri");
    }

    private static final ParameterizedTypeReference<CamResultDTO<List<AppMappingsDTO>>> AppMappingsDTOListType = new ParameterizedTypeReference<CamResultDTO<List<AppMappingsDTO>>>() {
    };


    /**
     * 获取钉钉集成应用信息
     */
    public static final String APP_MAPPINGS_CAM = getCamUri() + "/api/cam/v1/app/mappings?code=";

    public static CamResultDTO<List<AppMappingsDTO>> getAppMappings(String userToken, String appCode) {
        String url = APP_MAPPINGS_CAM + appCode;
        return DwSpringHttpUtil.get(url, AppMappingsDTOListType, httpHeaders -> {
            httpHeaders.set(DwHttpHeaderConstants.Header_User_Token, userToken);
            httpHeaders.set(DwHttpHeaderConstants.Header_App_Token, DwHttpHeaderConstants.App_Token_Athena);
        }, Collections.emptyMap());

    }


}
