/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.athena.manager.common.util;

import com.digiwin.athena.appcore.auth.AppAuthContextHolder;
import com.digiwin.athena.appcore.auth.domain.AuthoredUser;
import com.jugg.agile.spring.util.JaSpringBeanUtil;
import java.util.Collections;
import java.util.Map;
import java.util.function.Function;
import org.springframework.context.i18n.LocaleContextHolder;
import org.springframework.core.ParameterizedTypeReference;
import org.springframework.http.HttpEntity;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpMethod;
import org.springframework.http.MediaType;
import org.springframework.http.ResponseEntity;
import org.springframework.lang.Nullable;
import org.springframework.util.MultiValueMap;
import org.springframework.web.client.RestTemplate;

public class DwAHttpUtil {
    public static <T> T get(String uri, Map<String, String> param, ParameterizedTypeReference<T> responseType) {
        RestTemplate restTemplate = DwAHttpUtil.getRestTemplate();
        HttpHeaders headers = DwAHttpUtil.getHttpHeaders();
        HttpEntity httpEntity = new HttpEntity((MultiValueMap)headers);
        ResponseEntity respEntity = restTemplate.exchange(uri, HttpMethod.GET, httpEntity, responseType, param);
        return (T)respEntity.getBody();
    }

    private static RestTemplate getRestTemplate() {
        return (RestTemplate)JaSpringBeanUtil.getBean(RestTemplate.class);
    }

    public static <T> T get(String urlString, Class<T> tClass) {
        RestTemplate restTemplate = DwAHttpUtil.getRestTemplate();
        HttpHeaders headers = DwAHttpUtil.getHttpHeaders();
        HttpEntity httpEntity = new HttpEntity((MultiValueMap)headers);
        ResponseEntity respEntity = restTemplate.exchange(urlString, HttpMethod.GET, httpEntity, tClass, new Object[0]);
        return (T)respEntity.getBody();
    }

    private static HttpHeaders getHttpHeaders() {
        HttpHeaders headers = new HttpHeaders();
        headers.setContentType(MediaType.APPLICATION_JSON);
        AuthoredUser authoredUser = AppAuthContextHolder.getContext().getAuthoredUser();
        headers.add("token", authoredUser.getToken());
        headers.add("locale", LocaleContextHolder.getLocale().toString());
        return headers;
    }

    public static <T> T get(String urlString, ParameterizedTypeReference<T> responseType) {
        HttpHeaders headers = DwAHttpUtil.getHttpHeaders();
        HttpEntity httpEntity = new HttpEntity((MultiValueMap)headers);
        return DwAHttpUtil.exchange(urlString, HttpMethod.GET, responseType, httpEntity, Collections.emptyMap());
    }

    public static <T> T get(String urlString, Class<T> responseType, Map<String, Object> uriVariables) {
        return DwAHttpUtil.exchange(urlString, HttpMethod.GET, responseType, null, uriVariables);
    }

    public static <T> T post(String urlString, Object body, ParameterizedTypeReference<T> responseType) {
        return DwAHttpUtil.post(urlString, body, responseType, null);
    }

    public static <T> T post(String urlString, Object body, ParameterizedTypeReference<T> responseType, Function<HttpHeaders, HttpHeaders> headerFunction) {
        HttpHeaders headers = DwAHttpUtil.getHttpHeaders();
        if (headerFunction != null) {
            headers = headerFunction.apply(headers);
        }
        HttpEntity httpEntity = new HttpEntity(body, (MultiValueMap)headers);
        return DwAHttpUtil.exchange(urlString, HttpMethod.POST, responseType, httpEntity, Collections.emptyMap());
    }

    public static <T> T post(String urlString, Object body, Class<T> responseType) {
        HttpHeaders headers = DwAHttpUtil.getHttpHeaders();
        HttpEntity httpEntity = new HttpEntity(body, (MultiValueMap)headers);
        return DwAHttpUtil.exchange(urlString, HttpMethod.POST, responseType, httpEntity, Collections.emptyMap());
    }

    private static <T> T exchange(String urlString, HttpMethod httpMethod, Class<T> tClass, @Nullable HttpEntity<?> requestEntity, Map<String, ?> uriVariables) {
        RestTemplate restTemplate = DwAHttpUtil.getRestTemplate();
        ResponseEntity respEntity = restTemplate.exchange(urlString, httpMethod, requestEntity, tClass, uriVariables);
        return (T)respEntity.getBody();
    }

    private static <T> T exchange(String urlString, HttpMethod httpMethod, ParameterizedTypeReference<T> responseType, @Nullable HttpEntity<?> requestEntity, Map<String, ?> uriVariables) {
        RestTemplate restTemplate = DwAHttpUtil.getRestTemplate();
        ResponseEntity respEntity = restTemplate.exchange(urlString, httpMethod, requestEntity, responseType, uriVariables);
        return (T)respEntity.getBody();
    }
}

