package com.digiwin.athena.appcore.auth;

import com.jugg.agile.framework.core.util.concurrent.JaThreadLocal;

/**
 * 与原来 com.digiwin.athena.appcore.auth.AppAuthContextHolder 保持一致
 * @author gengwei
 * @since 2024/8/19 10:44
 */
public class AppAuthContextHolder {

    private static final JaThreadLocal<AppAuthContext> contextHolder = new JaThreadLocal<>();

    AppAuthContextHolder() {
    }

    /**
     * 请空当前线程数据
     */
    public static void clearContext() {
        contextHolder.remove();
    }

    /**
     * 获取当前登录成功的数据
     *
     * @return
     */
    public static AppAuthContext getContext() {
        AppAuthContext ctx = contextHolder.get();
        if (ctx == null) {
            ctx = createEmptyContext();
            contextHolder.set(ctx);
        }
        return ctx;
    }

    /**
     * 设置当前登录的数据
     *
     * @param context
     */
    public static void setContext(AppAuthContext context) {
        contextHolder.set(context);
    }

    /**
     * 创建空的数据
     *
     * @return
     */
    public static AppAuthContext createEmptyContext() {
        return new AppAuthContext();
    }


}
