package com.digiwin.athena.manager.common.util;

import com.digiwin.athena.appcore.auth.AppAuthContextHolder;
import com.digiwin.athena.appcore.auth.domain.AuthoredUser;
import com.jugg.agile.spring.util.JaSpringBeanUtil;
import org.springframework.context.i18n.LocaleContextHolder;
import org.springframework.core.ParameterizedTypeReference;
import org.springframework.http.HttpEntity;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpMethod;
import org.springframework.http.MediaType;
import org.springframework.http.ResponseEntity;
import org.springframework.lang.Nullable;
import org.springframework.web.client.RestTemplate;

import java.util.Collections;
import java.util.Map;
import java.util.function.Function;

/**
 * 通用的通过restTemplate 调用外部服务工具类
 *
 * @author gengwei
 * @date 2024/8/19 10:51
 **/
public class DwAHttpUtil {

    /**
     * 1. 找一个ask的接口, 走了去中心化
     * 2. get bean restTemplate
     * 3. 了解kg和sd的返回 ; 现在返回的是BaseResultDTO, 需要了解真实的返回是什么
     * 4. 最终需要 code messsag body
     */
    public static <T> T get(String uri, Map<String, String> param, ParameterizedTypeReference<T> responseType) {
        RestTemplate restTemplate = getRestTemplate();

        HttpHeaders headers = getHttpHeaders();
//        addLang(headers);


        HttpEntity<?> httpEntity = new HttpEntity<>(headers);
        ResponseEntity<T> respEntity = restTemplate.exchange(uri, HttpMethod.GET, httpEntity, responseType, param);
        return respEntity.getBody();

    }

    private static RestTemplate getRestTemplate() {
        return JaSpringBeanUtil.getBean(RestTemplate.class);
    }

    // ------------------------------------------------------- get start -------------------------------------------------------

    /**
     * 发送get请求
     *
     * @param urlString 网址
     * @return 返回内容，如果只检查状态码，正常只返回 ""，不正常返回 null
     */
    public static <T> T get(String urlString, Class<T> tClass) {
        RestTemplate restTemplate = getRestTemplate();
        HttpHeaders headers = getHttpHeaders();
        HttpEntity<?> httpEntity = new HttpEntity<>(headers);

        ResponseEntity<T> respEntity = restTemplate.exchange(urlString, HttpMethod.GET, httpEntity, tClass);
        return respEntity.getBody();
    }


    public static <T> T get(String urlString, ParameterizedTypeReference<T> responseType) {
        HttpHeaders headers = getHttpHeaders();
        HttpEntity<?> httpEntity = new HttpEntity<>(headers);
        return exchange(urlString, HttpMethod.GET, responseType, httpEntity, Collections.emptyMap());
    }

    /**
     * 发送get请求
     *
     * @param urlString    网址
     * @param uriVariables url中占位符参数
     * @return 返回数据
     */
    public static <T> T get(String urlString, Class<T> responseType, Map<String, Object> uriVariables) {
        return exchange(urlString, HttpMethod.GET, responseType, null, uriVariables);
    }

    // ------------------------------------------------------- get end-------------------------------------------------------


    // ------------------------------------------------------- post start-------------------------------------------------------

    /**
     * 发送post请求
     *
     * @param urlString 网址
     * @param body      body 数据
     * @return 返回数据
     */
    public static <T> T post(String urlString, Object body, ParameterizedTypeReference<T> responseType) {
        return post(urlString, body, responseType, headers -> headers);
    }

    public static <T> T post(String urlString, Object body, ParameterizedTypeReference<T> responseType, Map<String, Object> uriVariables) {
        return post(urlString, body, responseType, null, uriVariables);
    }

    /**
     * 发送post请求
     *
     * @param urlString 网址
     * @param body      body 数据
     * @return 返回数据
     */
    public static <T> T post(String urlString, Object body, ParameterizedTypeReference<T> responseType, Function<HttpHeaders, HttpHeaders> headerFunction) {
        HttpHeaders headers = getHttpHeaders(headerFunction);
        HttpEntity<?> httpEntity = new HttpEntity<>(body, headers);
        return exchange(urlString, HttpMethod.POST, responseType, httpEntity, Collections.emptyMap());

    }

    public static <T> T post(String urlString, Object body, ParameterizedTypeReference<T> responseType, Function<HttpHeaders, HttpHeaders> headerFunction, Map<String, Object> uriVariables) {
        HttpHeaders headers = getHttpHeaders(headerFunction);
        HttpEntity<?> httpEntity = new HttpEntity<>(body, headers);
        return exchange(urlString, HttpMethod.POST, responseType, httpEntity, uriVariables);

    }

    private static HttpHeaders getHttpHeaders(Function<HttpHeaders, HttpHeaders> headerFunction) {
        HttpHeaders headers = getHttpHeaders();
        if (headerFunction != null) {
            headers = headerFunction.apply(headers);
        }
        return headers;
    }

    /**
     * 发送post请求
     *
     * @param urlString 网址
     * @param body      body 数据
     * @return 返回数据
     */
    public static <T> T post(String urlString, Object body, Class<T> responseType) {
        HttpHeaders headers = getHttpHeaders();
        HttpEntity<?> httpEntity = new HttpEntity<>(body, headers);
        return exchange(urlString, HttpMethod.POST, responseType, httpEntity, Collections.emptyMap());

    }

    public static <T> T post(String urlString, Object body, Class<T> responseType, Function<HttpHeaders, HttpHeaders> headerFunction) {
        HttpHeaders headers = getHttpHeaders(headerFunction);
        HttpEntity<?> httpEntity = new HttpEntity<>(body, headers);
        return exchange(urlString, HttpMethod.POST, responseType, httpEntity, Collections.emptyMap());

    }

    // ------------------------------------------------------- post end-------------------------------------------------------


    /**
     * 调用spring restTemplate.exchange 方法
     *
     * @param urlString
     * @param httpMethod
     * @param tClass
     * @param requestEntity
     * @param uriVariables
     * @author gengwei
     **/
    private static <T> T exchange(String urlString, HttpMethod httpMethod, Class<T> tClass, @Nullable HttpEntity<?> requestEntity, Map<String, ?> uriVariables) {
        RestTemplate restTemplate = getRestTemplate();
        ResponseEntity<T> respEntity = restTemplate.exchange(urlString, httpMethod, requestEntity, tClass, uriVariables);
        return respEntity.getBody();
    }

    private static <T> T exchange(String urlString, HttpMethod httpMethod, ParameterizedTypeReference<T> responseType, @Nullable HttpEntity<?> requestEntity, Map<String, ?> uriVariables) {
        RestTemplate restTemplate = getRestTemplate();
        ResponseEntity<T> respEntity = restTemplate.exchange(urlString, httpMethod, requestEntity, responseType, uriVariables);
        return respEntity.getBody();
    }


    private static HttpHeaders getHttpHeaders() {
        HttpHeaders headers = new HttpHeaders();
        headers.setContentType(MediaType.APPLICATION_JSON);
        AuthoredUser authoredUser = AppAuthContextHolder.getContext().getAuthoredUser();
        if (authoredUser != null) {
            headers.add("token", authoredUser.getToken());
        }

        headers.add("locale", LocaleContextHolder.getLocale().toString());
        return headers;
    }

}
