package com.digiwin.athena.appcore.auth.domain;

import org.springframework.util.Assert;

/**
 * 与原来 com.digiwin.athena.appcore.auth.domain.IamGrantedAuthority 保持一致
 *
 * @author gengwei
 * @since 2024/8/19 10:47
 */
public class IamGrantedAuthority {
    private static final long serialVersionUID = 520L;
    private final String role;
    private final String roleName;
    private final Long roleSid;

    public IamGrantedAuthority(Long sid, String id, String name) {
        Assert.hasText(id, "A granted authority textual representation is required");
        this.role = id;
        this.roleName = name;
        this.roleSid = sid;
    }

    public String getAuthority() {
        return this.role;
    }

    public String getRole() {
        return role;
    }

    public String getRoleName() {
        return roleName;
    }

    public Long getRoleSid() {
        return roleSid;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        } else {
            return obj instanceof IamGrantedAuthority ? this.role.equals(((IamGrantedAuthority) obj).role) : false;
        }
    }

    public int hashCode() {
        return this.role.hashCode();
    }

    public String toString() {
        return this.role + "-" + this.roleName;
    }
}
