package com.digiwin.athena.manager.common.meta;

import lombok.*;
import lombok.experimental.SuperBuilder;

import java.util.Map;


@Setter
@Getter
@SuperBuilder
@AllArgsConstructor
@NoArgsConstructor
public class BaseResultDTO<T> {
    private T response;

    private Integer status;
    private String statusDescription;

    private String errorType;
    private String errorMessage;
    private String errorCode;

    private Object debugInfo;
    /**
     * 错误响应时，包含调用链信息：chainInfo
     */
    private Map<String, Object> errorInstructors;
}
