package com.digiwin.athena.manager.common.util;

import com.digiwin.athena.appcore.auth.AppAuthContextHolder;
import com.digiwin.athena.appcore.auth.domain.AuthoredUser;
import com.jugg.agile.framework.core.meta.function.JaFunctionRP;
import com.jugg.agile.spring.util.JaSpringBeanUtil;
import org.springframework.context.i18n.LocaleContextHolder;
import org.springframework.core.ParameterizedTypeReference;
import org.springframework.http.*;
import org.springframework.web.client.RestTemplate;

import java.util.*;

/**
 * 通用的通过restTemplate 调用外部服务工具类
 *
 * @author gengwei
 * @date 2024/8/19 10:51
 **/
public class DwSpringHttpUtil {

    private DwSpringHttpUtil() {
    }

    /**
     * get 请求
     */
    public static <T> T get(String url, ParameterizedTypeReference<T> responseType) {
        return get(url, responseType, headers -> headers, Collections.emptyMap());
    }

    /**
     * get 请求
     */
    public static <T> T get(String url, ParameterizedTypeReference<T> responseType, Map<String, ?> uriVariables) {
        return get(url, responseType, headers -> headers, uriVariables);
    }

    public static <T> T get(String url, ParameterizedTypeReference<T> responseType, JaFunctionRP<HttpHeaders, HttpHeaders> headerJaFunctionRP, Map<String, ?> uriVariables) {
        HttpHeaders headers = wrapHttpHeaders(headerJaFunctionRP);
        HttpEntity<?> httpEntity = new HttpEntity<>(headers);
        return exchange(url, HttpMethod.GET, httpEntity, responseType, uriVariables);
    }

    /**
     * 发送post请求
     */
    public static <T> T post(String url, Object body, ParameterizedTypeReference<T> responseType) {
        return post(url, body, responseType, headers -> headers);
    }

    public static <T> T post(String url, Object body, ParameterizedTypeReference<T> responseType, Map<String, Object> uriVariables) {
        return post(url, body, responseType, null, uriVariables);
    }

    /**
     * 发送post请求
     */
    public static <T> T post(String url, Object body, ParameterizedTypeReference<T> responseType, JaFunctionRP<HttpHeaders, HttpHeaders> headerJaFunctionRP) {
        return post(url, body, responseType, headerJaFunctionRP, Collections.emptyMap());
    }

    public static <T> T post(String url, Object body, ParameterizedTypeReference<T> responseType, JaFunctionRP<HttpHeaders, HttpHeaders> headerJaFunctionRP, Map<String, Object> uriVariables) {
        HttpHeaders headers = wrapHttpHeaders(headerJaFunctionRP);
        HttpEntity<?> httpEntity = new HttpEntity<>(body, headers);
        return exchange(url, HttpMethod.POST, httpEntity, responseType, uriVariables);
    }

    /**
     * 调用spring restTemplate.exchange 方法
     *
     * @author gengwei
     **/
    private static <T> T exchange(String url, HttpMethod httpMethod, HttpEntity<?> requestEntity, Class<T> tClass, Map<String, ?> uriVariables) {
        ResponseEntity<T> respEntity = Instance.restTemplate.exchange(url, httpMethod, requestEntity, tClass, uriVariables);
        return respEntity.getBody();
    }

    private static <T> T exchange(String url, HttpMethod httpMethod, HttpEntity<?> requestEntity, ParameterizedTypeReference<T> responseType, Map<String, ?> uriVariables) {
        ResponseEntity<T> respEntity = Instance.restTemplate.exchange(url, httpMethod, requestEntity, responseType, uriVariables);
        return respEntity.getBody();
    }


    private static HttpHeaders wrapHttpHeaders(JaFunctionRP<HttpHeaders, HttpHeaders> headerJaFunctionRP) {
        HttpHeaders headers = initHttpHeaders();
        if (headerJaFunctionRP != null) {
            headers = headerJaFunctionRP.apply(headers);
        }
        return headers;
    }

    private static HttpHeaders initHttpHeaders() {
        HttpHeaders headers = new HttpHeaders();
        headers.setContentType(MediaType.APPLICATION_JSON);
        AuthoredUser authoredUser = AppAuthContextHolder.getContext().getAuthoredUser();
        if (authoredUser != null) {
            headers.add("token", authoredUser.getToken());
        }

        headers.add("locale", LocaleContextHolder.getLocale().toString());
        return headers;
    }

    private static class Instance {
        private static final RestTemplate restTemplate = JaSpringBeanUtil.getBean(RestTemplate.class);
    }
}
