package com.digiwin.athena.appcore.auth;

import com.digiwin.athena.appcore.auth.domain.AuthoredSys;
import com.digiwin.athena.appcore.auth.domain.AuthoredUser;
import org.springframework.util.Assert;

import java.io.Serializable;

/**
 * 与原来 com.digiwin.athena.appcore.auth.AppAuthContext 保持一致
 *
 * @author gengwei
 * @since 2024/8/19 10:45
 */
public class AppAuthContext implements Serializable {
    /**
     * 登录成功用户
     */
    private AuthoredUser authoredUser;

    /**
     * 代理token的用户
     */
    private AuthoredUser proxyAuthoredUser;

    /**
     * 代理的token
     */
    private String proxyToken;

    /**
     * 登录的sys
     */
    private AuthoredSys authoredSys;

    /**
     * 信任链用的key，减少多次调用iam的api
     */
    private String securityToken;

    public AppAuthContext() {

    }

    /**
     * 构造函数
     *
     * @param authoredUser
     * @param authoredSys
     */
    public AppAuthContext(AuthoredUser authoredUser, AuthoredSys authoredSys) {
        Assert.notNull(authoredUser, "authoredUser不能为null");
        this.authoredUser = authoredUser;
        this.authoredSys = authoredSys;
    }

    public AuthoredUser getAuthoredUser() {
        return authoredUser;
    }

    public void setAuthoredUser(AuthoredUser authoredUser) {
        this.authoredUser = authoredUser;
    }

    public AuthoredUser getProxyAuthoredUser() {
        return proxyAuthoredUser;
    }

    public void setProxyAuthoredUser(AuthoredUser proxyAuthoredUser) {
        this.proxyAuthoredUser = proxyAuthoredUser;
    }

    public AuthoredSys getAuthoredSys() {
        return authoredSys;
    }

    public void setAuthoredSys(AuthoredSys authoredSys) {
        this.authoredSys = authoredSys;
    }

    public String getProxyToken() {
        return proxyToken;
    }

    public void setProxyToken(String proxyToken) {
        this.proxyToken = proxyToken;
    }

    public String getSecurityToken() {
        return securityToken;
    }

    public void setSecurityToken(String securityToken) {
        this.securityToken = securityToken;
    }

    @Override
    public boolean equals(Object obj) {
        if (obj instanceof AppAuthContext) {
            AppAuthContext test = (AppAuthContext) obj;
            if (this.getAuthoredUser() == null && test.getAuthoredUser() == null &&
                    this.getAuthoredSys() == null && test.getAuthoredSys() == null
            ) {
                return true;
            }


            if (this.getAuthoredUser() != null && test.getAuthoredUser() != null && this.getAuthoredUser().equals(test.getAuthoredUser())
                    && this.getAuthoredSys() != null && test.getAuthoredSys() != null && this.getAuthoredSys().equals(test.getAuthoredSys())
            ) {
                return true;
            }
        }

        return false;
    }

    @Override
    public int hashCode() {
        int hash = this.authoredUser == null ? -1 : this.authoredUser.hashCode();
        int hash2 = this.authoredSys == null ? -1 : this.authoredSys.hashCode();
        return hash ^ hash2;
    }

}
