package com.digiwin.athena.common.sdk.manager.util;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;

import com.digiwin.athena.appcore.exception.BusinessException;
import com.jugg.agile.framework.core.util.JaStringUtil;
import com.jugg.agile.framework.meta.handler.JaResultParseHandler;
import org.springframework.core.ParameterizedTypeReference;
import org.springframework.http.converter.HttpMessageConversionException;
import org.springframework.web.client.ResourceAccessException;
import org.springframework.web.client.RestClientException;
import org.springframework.web.client.RestClientResponseException;

import java.util.Optional;

import static com.digiwin.athena.common.sdk.manager.meta.constants.CommonErrorCode.*;

public class DwHttpResultWapperUtil {

    @SuppressWarnings("all")
    public static <T> T postWapper(String url, Object body, ParameterizedTypeReference responseType) {
        JaResultParseHandler<T> result = null;
        try {
            result = (JaResultParseHandler<T>) DwSpringHttpUtil.post(url, body, responseType);
        } catch (ResourceAccessException ex) {
            //httpStatus!=200
            //访问其他组件时网络异常，请稍后重试 封装成BusinessException异常抛出
            throw BusinessException.buildErrorCode(P_AI_500_500);
        } catch (RestClientResponseException ex) {
            //400 500 错误  可以获取到responseBodyAsString进行解析获取errorCode和errorMessage进行透传 封装成BusinessException异常抛出
            parseRestClientResponseException((RestClientResponseException) ex);
        } catch (RestClientException ex) {
            //响应体解析错误
            if (ex.getCause() instanceof HttpMessageConversionException) {
                throw BusinessException.buildErrorCode(P_AI_500_506);
            }
            //其他未知异常直接向上抛出
            throw ex;
        }
        // 如果响应为空(一般响应不会为空)，直接透传 需要在使用方进行处理
        if (null == result) {
            return null;
        }
        if (!result.success()) {
            //httpStatus==200 需要透传服务方的错误信息
            throw BusinessException.create(result.code(), result.message()).buildLog(result.message());
        }
        return result.data();
    }

    private static void parseRestClientResponseException(RestClientResponseException ex) {
        JSONObject errorException = null;
        try {
            errorException = JSON.parseObject(ex.getResponseBodyAsString(), JSONObject.class);
        } catch (Exception e) {
            errorException = new JSONObject();
        }
        if (null == errorException) {
            throw BusinessException.buildErrorCode(P_AI_500_500);
        }
        String errorCode = getErrorCode(errorException);
        String errorMessage = getErrorMessage(errorException);
        throw BusinessException.create(errorCode, errorMessage).buildLog(errorMessage);
    }

    private static String getErrorCode(JSONObject errorException) {
        return Optional.ofNullable(errorException.getString("errorCode"))
                .filter(code -> !JaStringUtil.isEmpty(code))
                .orElse(P_AI_500_500);
    }

    private static String getErrorMessage(JSONObject errorException) {
        return errorException.getString("errorMessage");
    }

}
