package com.digiwin.athena.common.sdk.manager.util;

import com.digiwin.athena.appcore.auth.AppAuthContextHolder;
import com.digiwin.athena.appcore.auth.domain.AuthoredUser;
import com.jugg.agile.framework.core.meta.function.JaFunctionP;
import com.jugg.agile.spring.util.JaSpringBeanUtil;
import org.springframework.context.i18n.LocaleContextHolder;
import org.springframework.core.ParameterizedTypeReference;
import org.springframework.http.HttpEntity;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpMethod;
import org.springframework.http.MediaType;
import org.springframework.http.ResponseEntity;
import org.springframework.web.client.RestTemplate;

import java.util.Collections;
import java.util.Map;

/**
 * 通用的通过restTemplate 调用外部服务工具类
 *
 * @author gengwei
 * @since 2024/8/19 10:51
 **/
public class DwSpringHttpUtil {

    private DwSpringHttpUtil() {
    }

    /**
     * get 请求
     */
    public static <T> T get(String url, ParameterizedTypeReference<T> responseType) {
        return get(url, responseType, null, Collections.emptyMap());
    }

    /**
     * get 请求
     */
    public static <T> T get(String url, ParameterizedTypeReference<T> responseType, Map<String, ?> uriVariables) {
        return get(url, responseType, null, uriVariables);
    }

    public static <T> T get(String url, ParameterizedTypeReference<T> responseType, JaFunctionP<HttpHeaders> headerJaFunctionRP, Map<String, ?> uriVariables) {
        HttpHeaders headers = wrapHttpHeaders(headerJaFunctionRP);
        HttpEntity<?> httpEntity = new HttpEntity<>(headers);
        return exchange(url, HttpMethod.GET, httpEntity, responseType, uriVariables);
    }

    /**
     * 发送post请求
     */
    public static <T> T post(String url, Object body, ParameterizedTypeReference<T> responseType) {
        return post(url, body, responseType, null, Collections.emptyMap());
    }

    public static <T> T post(String url, Object body, ParameterizedTypeReference<T> responseType, Map<String, Object> uriVariables) {
        return post(url, body, responseType, null, uriVariables);
    }

    /**
     * 发送post请求
     */
    public static <T> T post(String url, Object body, ParameterizedTypeReference<T> responseType, JaFunctionP<HttpHeaders> headerJaFunctionRP) {
        return post(url, body, responseType, headerJaFunctionRP, Collections.emptyMap());
    }

    public static <T> T post(String url, Object body, ParameterizedTypeReference<T> responseType, JaFunctionP<HttpHeaders> headerJaFunctionRP, Map<String, Object> uriVariables) {
        HttpHeaders headers = wrapHttpHeaders(headerJaFunctionRP);
        HttpEntity<?> httpEntity = new HttpEntity<>(body, headers);
        return exchange(url, HttpMethod.POST, httpEntity, responseType, uriVariables);
    }

    /**
     * 调用spring restTemplate.exchange 方法
     *
     * @author gengwei
     **/
    private static <T> T exchange(String url, HttpMethod httpMethod, HttpEntity<?> requestEntity, Class<T> tClass, Map<String, ?> uriVariables) {
        ResponseEntity<T> respEntity = Instance.restTemplate.exchange(url, httpMethod, requestEntity, tClass, uriVariables);
        return respEntity.getBody();
    }

    private static <T> T exchange(String url, HttpMethod httpMethod, HttpEntity<?> requestEntity, ParameterizedTypeReference<T> responseType, Map<String, ?> uriVariables) {
        ResponseEntity<T> respEntity = Instance.restTemplate.exchange(url, httpMethod, requestEntity, responseType, uriVariables);
        return respEntity.getBody();
    }


    private static HttpHeaders wrapHttpHeaders(JaFunctionP<HttpHeaders> headerJaFunctionRP) {
        HttpHeaders headers = initHttpHeaders();
        if (headerJaFunctionRP != null) {
            headerJaFunctionRP.apply(headers);
        }
        return headers;
    }

    private static HttpHeaders initHttpHeaders() {
        HttpHeaders headers = new HttpHeaders();
        headers.setContentType(MediaType.APPLICATION_JSON);
        AuthoredUser authoredUser = AppAuthContextHolder.getContext().getAuthoredUser();
        if (authoredUser != null) {
            headers.add("token", authoredUser.getToken());
        }

        headers.add("locale", LocaleContextHolder.getLocale().toString());
        return headers;
    }

    private static class Instance {
        private static final RestTemplate restTemplate = JaSpringBeanUtil.getBean(RestTemplate.class);
    }
}
