/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.athena.common.sdk.manager.util;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.digiwin.athena.appcore.exception.BusinessException;
import com.digiwin.athena.common.sdk.manager.util.DwSpringHttpUtil;
import com.jugg.agile.framework.core.util.JaStringUtil;
import com.jugg.agile.framework.meta.handler.JaResultParseHandler;
import java.util.Optional;
import org.springframework.core.ParameterizedTypeReference;
import org.springframework.http.converter.HttpMessageConversionException;
import org.springframework.web.client.ResourceAccessException;
import org.springframework.web.client.RestClientException;
import org.springframework.web.client.RestClientResponseException;

public class DwHttpResultWapperUtil {
    public static <T> T postWapper(String url, Object body, ParameterizedTypeReference responseType) {
        JaResultParseHandler result = null;
        try {
            result = (JaResultParseHandler)DwSpringHttpUtil.post(url, body, responseType);
        }
        catch (ResourceAccessException ex) {
            throw BusinessException.buildErrorCode((String)"P.AI.500.500");
        }
        catch (RestClientResponseException ex) {
            DwHttpResultWapperUtil.parseRestClientResponseException(ex);
        }
        catch (RestClientException ex) {
            if (ex.getCause() instanceof HttpMessageConversionException) {
                throw BusinessException.buildErrorCode((String)"P.AI.500.506");
            }
            throw ex;
        }
        if (null == result) {
            return null;
        }
        if (!result.success().booleanValue()) {
            throw BusinessException.create((String)result.code(), (String)result.message()).buildLog(result.message());
        }
        return (T)result.data();
    }

    private static void parseRestClientResponseException(RestClientResponseException ex) {
        JSONObject errorException = null;
        try {
            errorException = (JSONObject)JSON.parseObject((String)ex.getResponseBodyAsString(), JSONObject.class);
        }
        catch (Exception e) {
            errorException = new JSONObject();
        }
        if (null == errorException) {
            throw BusinessException.buildErrorCode((String)"P.AI.500.500");
        }
        String errorCode = DwHttpResultWapperUtil.getErrorCode(errorException);
        String errorMessage = DwHttpResultWapperUtil.getErrorMessage(errorException);
        throw BusinessException.create((String)errorCode, (String)errorMessage).buildLog(errorMessage);
    }

    private static String getErrorCode(JSONObject errorException) {
        return Optional.ofNullable(errorException.getString("errorCode")).filter(code -> !JaStringUtil.isEmpty((String)code)).orElse("P.AI.500.500");
    }

    private static String getErrorMessage(JSONObject errorException) {
        return errorException.getString("errorMessage");
    }
}

