/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.athena.common.sdk.manager.util;

import com.digiwin.athena.appcore.auth.AppAuthContextHolder;
import com.digiwin.athena.appcore.auth.domain.AuthoredUser;
import com.jugg.agile.framework.core.meta.function.JaFunctionP;
import com.jugg.agile.spring.util.JaSpringBeanUtil;
import java.util.Collections;
import java.util.Map;
import org.springframework.context.i18n.LocaleContextHolder;
import org.springframework.core.ParameterizedTypeReference;
import org.springframework.http.HttpEntity;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpMethod;
import org.springframework.http.MediaType;
import org.springframework.http.ResponseEntity;
import org.springframework.util.MultiValueMap;
import org.springframework.web.client.RestTemplate;

public class DwSpringHttpUtil {
    private DwSpringHttpUtil() {
    }

    public static <T> T get(String url, ParameterizedTypeReference<T> responseType) {
        return DwSpringHttpUtil.get(url, responseType, null, Collections.emptyMap());
    }

    public static <T> T get(String url, ParameterizedTypeReference<T> responseType, Map<String, ?> uriVariables) {
        return DwSpringHttpUtil.get(url, responseType, null, uriVariables);
    }

    public static <T> T get(String url, ParameterizedTypeReference<T> responseType, JaFunctionP<HttpHeaders> headerJaFunctionRP, Map<String, ?> uriVariables) {
        HttpHeaders headers = DwSpringHttpUtil.wrapHttpHeaders(headerJaFunctionRP);
        HttpEntity httpEntity = new HttpEntity((MultiValueMap)headers);
        return DwSpringHttpUtil.exchange(url, HttpMethod.GET, httpEntity, responseType, uriVariables);
    }

    public static <T> T post(String url, Object body, ParameterizedTypeReference<T> responseType) {
        return DwSpringHttpUtil.post(url, body, responseType, null, Collections.emptyMap());
    }

    public static <T> T post(String url, Object body, ParameterizedTypeReference<T> responseType, Map<String, Object> uriVariables) {
        return DwSpringHttpUtil.post(url, body, responseType, null, uriVariables);
    }

    public static <T> T post(String url, Object body, ParameterizedTypeReference<T> responseType, JaFunctionP<HttpHeaders> headerJaFunctionRP) {
        return DwSpringHttpUtil.post(url, body, responseType, headerJaFunctionRP, Collections.emptyMap());
    }

    public static <T> T post(String url, Object body, ParameterizedTypeReference<T> responseType, JaFunctionP<HttpHeaders> headerJaFunctionRP, Map<String, Object> uriVariables) {
        HttpHeaders headers = DwSpringHttpUtil.wrapHttpHeaders(headerJaFunctionRP);
        HttpEntity httpEntity = new HttpEntity(body, (MultiValueMap)headers);
        return DwSpringHttpUtil.exchange(url, HttpMethod.POST, httpEntity, responseType, uriVariables);
    }

    private static <T> T exchange(String url, HttpMethod httpMethod, HttpEntity<?> requestEntity, Class<T> tClass, Map<String, ?> uriVariables) {
        ResponseEntity respEntity = Instance.restTemplate.exchange(url, httpMethod, requestEntity, tClass, uriVariables);
        return (T)respEntity.getBody();
    }

    private static <T> T exchange(String url, HttpMethod httpMethod, HttpEntity<?> requestEntity, ParameterizedTypeReference<T> responseType, Map<String, ?> uriVariables) {
        ResponseEntity respEntity = Instance.restTemplate.exchange(url, httpMethod, requestEntity, responseType, uriVariables);
        return (T)respEntity.getBody();
    }

    private static HttpHeaders wrapHttpHeaders(JaFunctionP<HttpHeaders> headerJaFunctionRP) {
        HttpHeaders headers = DwSpringHttpUtil.initHttpHeaders();
        if (headerJaFunctionRP != null) {
            headerJaFunctionRP.apply((Object)headers);
        }
        return headers;
    }

    private static HttpHeaders initHttpHeaders() {
        HttpHeaders headers = new HttpHeaders();
        headers.setContentType(MediaType.APPLICATION_JSON);
        AuthoredUser authoredUser = AppAuthContextHolder.getContext().getAuthoredUser();
        if (authoredUser != null) {
            headers.add("token", authoredUser.getToken());
        }
        headers.add("locale", LocaleContextHolder.getLocale().toString());
        return headers;
    }

    private static class Instance {
        private static final RestTemplate restTemplate = (RestTemplate)JaSpringBeanUtil.getBean(RestTemplate.class);

        private Instance() {
        }
    }
}

