package com.digiwin.athena.common.sdk.manager.util;

import com.digiwin.athena.appcore.exception.BusinessException;
import com.jugg.agile.framework.meta.function.JaFunctionR;
import com.jugg.agile.framework.meta.handler.JaResultParseHandler;

public class DwHttpResultParseUtil {

    private DwHttpResultParseUtil() {
    }

    /**
     * 调用的接口返回的报错信息没已经做了国际化处理直接透传
     */
    public static <T> T parse(JaFunctionR<JaResultParseHandler<T>> business) {
        return parse(business, false);
    }

    public static <T> T parse(JaResultParseHandler<T> result) {
        return parse(result, false);
    }

    /**
     * 调用的接口返回的报错信息没有做国际化处理
     */
    public static <T> T parseI18n(JaFunctionR<JaResultParseHandler<T>> business) {
        return parse(business, true);
    }

    public static <T> T parse(JaFunctionR<JaResultParseHandler<T>> business, boolean isNeedI18n) {
        return parse(business.apply(), isNeedI18n);
    }

    public static <T> T parse(JaResultParseHandler<T> result, boolean isNeedI18n) {
        // 如果响应为空(一般响应不会为空)，直接透传 需要在使用方进行处理
        if (null == result) {
            return null;
        }
        if (Boolean.TRUE.equals(result.success())) {
            return result.data();
        }
        // httpStatus==200 需要透传服务方的错误信息
        if (isNeedI18n) {
            //如果对方接口没有国际化则封装统一国际化报错信息
            throw BusinessException.buildErrorCode(result.code()).buildLog(result.message());
        } else {
            //如果对方接口已经有国际化直接透传
            throw BusinessException.create(result.code(), result.message()).buildLog(result.message());
        }

    }
}
