/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.athena.common.sdk.manager.util;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.digiwin.athena.appcore.auth.AppAuthContextHolder;
import com.digiwin.athena.appcore.auth.domain.AuthoredUser;
import com.digiwin.athena.appcore.exception.BusinessException;
import com.jugg.agile.framework.core.dapper.log.JaLog;
import com.jugg.agile.framework.core.meta.function.JaFunctionP;
import com.jugg.agile.framework.core.util.JaStringUtil;
import com.jugg.agile.spring.util.JaSpringBeanUtil;
import java.util.Collections;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.context.i18n.LocaleContextHolder;
import org.springframework.core.ParameterizedTypeReference;
import org.springframework.http.HttpEntity;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpMethod;
import org.springframework.http.MediaType;
import org.springframework.http.ResponseEntity;
import org.springframework.http.converter.HttpMessageConversionException;
import org.springframework.util.MultiValueMap;
import org.springframework.web.client.ResourceAccessException;
import org.springframework.web.client.RestClientException;
import org.springframework.web.client.RestClientResponseException;
import org.springframework.web.client.RestTemplate;

public class DwSpringHttpUtil {
    private static final Logger log = LoggerFactory.getLogger(DwSpringHttpUtil.class);
    private static RestTemplate restTemplate = null;

    private DwSpringHttpUtil() {
    }

    public static <T> T get(String url, ParameterizedTypeReference<T> responseType) {
        return DwSpringHttpUtil.get(url, responseType, null, Collections.emptyMap());
    }

    public static <T> T get(String url, ParameterizedTypeReference<T> responseType, Map<String, ?> uriVariables) {
        return DwSpringHttpUtil.get(url, responseType, null, uriVariables);
    }

    public static <T> T get(String url, ParameterizedTypeReference<T> responseType, JaFunctionP<HttpHeaders> headerJaFunctionRP, Map<String, ?> uriVariables) {
        HttpHeaders headers = DwSpringHttpUtil.wrapHttpHeaders(headerJaFunctionRP);
        HttpEntity httpEntity = new HttpEntity((MultiValueMap)headers);
        return DwSpringHttpUtil.exchange(url, HttpMethod.GET, httpEntity, responseType, uriVariables);
    }

    public static <T> T post(String url, Object body, ParameterizedTypeReference<T> responseType) {
        return DwSpringHttpUtil.post(url, body, responseType, null, Collections.emptyMap());
    }

    public static <T> T post(String url, Object body, ParameterizedTypeReference<T> responseType, Map<String, Object> uriVariables) {
        return DwSpringHttpUtil.post(url, body, responseType, null, uriVariables);
    }

    public static <T> T post(String url, Object body, ParameterizedTypeReference<T> responseType, JaFunctionP<HttpHeaders> headerJaFunctionRP) {
        return DwSpringHttpUtil.post(url, body, responseType, headerJaFunctionRP, Collections.emptyMap());
    }

    public static <T> T post(String url, Object body, ParameterizedTypeReference<T> responseType, JaFunctionP<HttpHeaders> headerJaFunctionRP, Map<String, Object> uriVariables) {
        HttpHeaders headers = DwSpringHttpUtil.wrapHttpHeaders(headerJaFunctionRP);
        HttpEntity httpEntity = new HttpEntity(body, (MultiValueMap)headers);
        return DwSpringHttpUtil.exchange(url, HttpMethod.POST, httpEntity, responseType, uriVariables);
    }

    private static <T> T exchange(String url, HttpMethod httpMethod, HttpEntity<?> requestEntity, Class<T> tClass, Map<String, ?> uriVariables) {
        ResponseEntity respEntity = DwSpringHttpUtil.getRestTemplate().exchange(url, httpMethod, requestEntity, tClass, uriVariables);
        return (T)respEntity.getBody();
    }

    private static <T> T exchange(String url, HttpMethod httpMethod, HttpEntity<?> requestEntity, ParameterizedTypeReference<T> responseType, Map<String, ?> uriVariables) {
        ResponseEntity respEntity = null;
        try {
            if (DwSpringHttpUtil.getRestTemplate() == null) {
                log.error("manager-sdk query restTemplate is null");
            }
            respEntity = DwSpringHttpUtil.getRestTemplate().exchange(url, httpMethod, requestEntity, responseType, uriVariables);
        }
        catch (ResourceAccessException ex) {
            throw BusinessException.buildErrorCode((String)"P.AI.500.5004");
        }
        catch (RestClientResponseException ex) {
            DwSpringHttpUtil.parseRestClientResponseException(url, ex);
        }
        catch (RestClientException ex) {
            if (ex.getCause() instanceof HttpMessageConversionException) {
                throw BusinessException.buildErrorCode((String)"P.AI.500.5006");
            }
            throw ex;
        }
        return (T)respEntity.getBody();
    }

    private static HttpHeaders wrapHttpHeaders(JaFunctionP<HttpHeaders> headerJaFunctionRP) {
        HttpHeaders headers = DwSpringHttpUtil.initHttpHeaders();
        if (headerJaFunctionRP != null) {
            headerJaFunctionRP.apply((Object)headers);
        }
        return headers;
    }

    private static HttpHeaders initHttpHeaders() {
        HttpHeaders headers = new HttpHeaders();
        headers.setContentType(MediaType.APPLICATION_JSON);
        AuthoredUser authoredUser = AppAuthContextHolder.getContext().getAuthoredUser();
        if (authoredUser != null) {
            headers.add("token", authoredUser.getToken());
        }
        headers.add("locale", LocaleContextHolder.getLocale().toString());
        return headers;
    }

    private static void parseRestClientResponseException(String url, RestClientResponseException ex) {
        JSONObject errorException = null;
        try {
            errorException = (JSONObject)JSON.parseObject((String)ex.getResponseBodyAsString(), JSONObject.class);
        }
        catch (Exception e) {
            JaLog.error((String)"{} error : {}", (Object[])new Object[]{url, e});
        }
        if (null == errorException) {
            throw BusinessException.buildErrorCode((String)"P.AI.500.5000");
        }
        String errorCode = DwSpringHttpUtil.getErrorCode(errorException);
        String errorMessage = DwSpringHttpUtil.getErrorMessage(errorException);
        throw BusinessException.create((String)errorCode, (String)errorMessage).buildLog(errorMessage);
    }

    private static String getErrorCode(JSONObject errorException) {
        return Optional.ofNullable(errorException.getString("errorCode")).filter(code -> !JaStringUtil.isEmpty((String)code)).orElse("P.AI.500.5000");
    }

    private static String getErrorMessage(JSONObject errorException) {
        return errorException.getString("errorMessage");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static RestTemplate getRestTemplate() {
        if (!Objects.isNull(restTemplate)) return restTemplate;
        Class<DwSpringHttpUtil> clazz = DwSpringHttpUtil.class;
        synchronized (DwSpringHttpUtil.class) {
            if (!Objects.isNull(restTemplate)) return restTemplate;
            restTemplate = (RestTemplate)JaSpringBeanUtil.getBean(RestTemplate.class);
            // ** MonitorExit[var0] (shouldn't be in output)
            return restTemplate;
        }
    }
}

