package com.digiwin.athena.datamap.sdk.manager;

import com.digiwin.athena.common.sdk.manager.util.DwSpringHttpUtil;
import com.digiwin.athena.datamap.sdk.meta.dto.response.DataMapResultDTO;
import com.digiwin.athena.datamap.sdk.meta.dto.response.TmDataEntryDTO;
import com.digiwin.athena.datamap.sdk.meta.dto.response.TmStartProjectDTO;
import com.jugg.agile.framework.core.config.JaProperty;
import org.springframework.core.ParameterizedTypeReference;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;

public final class DataMapManager {
    private DataMapManager() {
    }

    private static String getDataMapUri() {
        return JaProperty.get("datamap.uri");
    }

    private static final String GET_START_PROJECT_URL = getDataMapUri() + "/restful/standard/datamap/task/manualList";

    private static final String GET_DATA_ENTRY_URL = getDataMapUri() + "/restful/service/datamap/record/entries?effect={effect}";

    private static final String GET_STATEMENT_URL = getDataMapUri() + "/restful/service/datamap/record/statements?effect={effect}";

    private static final String GET_DATA_ENTRYNames_URL = getDataMapUri() + "/restful/service/datamap/record/activityNames";

    private static final ParameterizedTypeReference<DataMapResultDTO<List<TmStartProjectDTO>>> getStartProjectRespType = new ParameterizedTypeReference<DataMapResultDTO<List<TmStartProjectDTO>>>() {
    };

    private static final ParameterizedTypeReference<DataMapResultDTO<List<TmDataEntryDTO>>> getDataEntryRespType = new ParameterizedTypeReference<DataMapResultDTO<List<TmDataEntryDTO>>>() {
    };

    /**
     * 获取手动发起项目列表
     */
    public static DataMapResultDTO<List<TmStartProjectDTO>> getStartProjectList() {
        return DwSpringHttpUtil.get(GET_START_PROJECT_URL, getStartProjectRespType);
    }

    /**
     * 获取基础资料录入列表
     */
    public static DataMapResultDTO<List<TmDataEntryDTO>> getDataEntryList(String effect) {
        Map<String, Object> uriVariables = new HashMap<>();
        uriVariables.put("effect", effect);
        return DwSpringHttpUtil.get(GET_DATA_ENTRY_URL, getDataEntryRespType, uriVariables);
    }

    /**
     * 获取基础资料录入列表
     */
    public static DataMapResultDTO<List<TmDataEntryDTO>> getStatementList(String effect) {
        Map<String, Object> uriVariables = new HashMap<>();
        uriVariables.put("effect", effect);
        return DwSpringHttpUtil.get(GET_STATEMENT_URL, getDataEntryRespType, uriVariables);
    }

    /**
     * 获取基础资料报表名字
     */
    public static DataMapResultDTO<List<TmDataEntryDTO>> getDataEntryListNames(Set<String> codes) {
        Map<String, Object> query = new HashMap<>();
        Map<String, Object> uriVariables = new HashMap<>();
        uriVariables.put("code", codes);
        query.put("query",uriVariables);
        return DwSpringHttpUtil.post(GET_DATA_ENTRYNames_URL,query,getDataEntryRespType);
    }
}
