package com.digiwin.athena.emc.sdk.dto;

import com.jugg.agile.framework.meta.handler.JaResultParseHandler;
import lombok.AllArgsConstructor;
import lombok.Getter;
import lombok.NoArgsConstructor;
import lombok.Setter;
import lombok.experimental.SuperBuilder;
import org.springframework.http.HttpStatus;

/**
 * TaskEngine 返回包装类
 *
 * @author gengwei
 * @since 2024/8/20 14:56
 */
@Setter
@Getter
@SuperBuilder
@AllArgsConstructor
@NoArgsConstructor
public class EmcResultDTO<T> implements JaResultParseHandler<T> {

    private Integer code;
    private String message;
    private Boolean success;

    private T data;


    @Override
    public Boolean success() {
        if (null == code || null == success) {
            return false;
        }
        return HttpStatus.OK.equals(HttpStatus.resolve(code)) && Boolean.TRUE.equals(success);
    }

    @Override
    public String code() {
        return String.valueOf(code);
    }

    @Override
    public String message() {
        return getMessage();
    }

    @Override
    public T data() {
        return getData();
    }
}
