/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.athena.eoc.sdk.manager;

import com.alibaba.fastjson.JSONArray;
import com.digiwin.athena.common.sdk.manager.util.DwSpringHttpUtil;
import com.digiwin.athena.eoc.sdk.meta.dto.EocResultDTO;
import com.digiwin.athena.eoc.sdk.meta.dto.response.EocCompanyDTO;
import com.digiwin.athena.eoc.sdk.meta.dto.response.EocDeptDTO;
import com.digiwin.athena.eoc.sdk.meta.dto.response.EocDeptEmployeeDTO;
import com.digiwin.athena.eoc.sdk.meta.dto.response.EocEmployeeDTO;
import com.digiwin.athena.eoc.sdk.meta.dto.response.EocUserDeptDTO;
import com.digiwin.athena.eoc.sdk.meta.dto.response.ProxyUserDTO;
import com.jugg.agile.framework.core.config.JaProperty;
import com.jugg.agile.framework.core.util.io.serialize.json.JaJson;
import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.springframework.core.ParameterizedTypeReference;

public class EocCommonManager {
    private static final ParameterizedTypeReference<EocResultDTO<List<ProxyUserDTO>>> ProxyUserDTOListType = new ParameterizedTypeReference<EocResultDTO<List<ProxyUserDTO>>>(){};
    private static final ParameterizedTypeReference<EocResultDTO<ProxyUserDTO>> ProxyUserDTOType = new ParameterizedTypeReference<EocResultDTO<ProxyUserDTO>>(){};
    private static final ParameterizedTypeReference<EocDeptDTO> DeptListType = new ParameterizedTypeReference<EocDeptDTO>(){};
    private static final ParameterizedTypeReference<EocResultDTO<List<EocDeptEmployeeDTO>>> EocDeptEmployeeDTOListType = new ParameterizedTypeReference<EocResultDTO<List<EocDeptEmployeeDTO>>>(){};
    private static final ParameterizedTypeReference<EocResultDTO<EocEmployeeDTO>> EocEmployeeDTOType = new ParameterizedTypeReference<EocResultDTO<EocEmployeeDTO>>(){};
    private static final ParameterizedTypeReference<EocResultDTO<Map<Object, Object>>> MapType = new ParameterizedTypeReference<EocResultDTO<Map<Object, Object>>>(){};
    private static final ParameterizedTypeReference<EocResultDTO<EocUserDeptDTO>> EocUserDeptType = new ParameterizedTypeReference<EocResultDTO<EocUserDeptDTO>>(){};
    private static final ParameterizedTypeReference<EocResultDTO<JSONArray>> JSONArrayType = new ParameterizedTypeReference<EocResultDTO<JSONArray>>(){};
    private static final ParameterizedTypeReference<EocResultDTO<List<EocCompanyDTO>>> EocCompanyDTOType = new ParameterizedTypeReference<EocResultDTO<List<EocCompanyDTO>>>(){};
    public static final String EMP_AGENT_TARGET_URL = EocCommonManager.getCacUri() + "api/eoc/v2/emp/agent/target";
    public static final String PAGE_DEPT_CASCADE_URL = EocCommonManager.getCacUri() + "api/eoc/v2/dept/cascade?pageNum=1&pageSize={pageSize}";
    public static final String DEPT_EMPS_URL = EocCommonManager.getCacUri() + "api/eoc/v2/dept/emps";
    public static final String PAGE_DEPT_LIST_URL = EocCommonManager.getCacUri() + "api/eoc/v2/dept/list?pageNum=1&pageSize={pageSize}";
    public static final String EMP_AGENT_URL = EocCommonManager.getCacUri() + "api/eoc/v2/emp/agent";
    public static final String EMP_INFO_URL = EocCommonManager.getCacUri() + "api/eoc/v2/emp/info";
    public static final String PAGE_EMP_SIMPLE_URL = EocCommonManager.getCacUri() + "api/eoc/v2/emp/simple?pageNum=1&pageSize={pageSize}&params={params}";
    public static final String EMP_SUBORDINATE_URL = EocCommonManager.getCacUri() + "api/eoc/v2/emp/subordinate";
    public static final String EMP_DEPT_COMPANY_URL = EocCommonManager.getCacUri() + "/api/eoc/v2/emp/dept/company?userId=";

    private static String getCacUri() {
        return JaProperty.get((String)"eoc.uri");
    }

    public static EocResultDTO<List<ProxyUserDTO>> getProxyTargetUsers(String userId, String token) {
        HashMap<String, String> param = new HashMap<String, String>(1);
        param.put("userId", userId);
        return (EocResultDTO)DwSpringHttpUtil.post((String)EMP_AGENT_TARGET_URL, param, ProxyUserDTOListType, httpHeaders -> httpHeaders.add("digi-middleware-auth-user", token));
    }

    public static EocDeptDTO queryAllDeptAndEmployee() {
        HashMap<String, Integer> params = new HashMap<String, Integer>();
        params.put("pageSize", 2000);
        return (EocDeptDTO)DwSpringHttpUtil.get((String)PAGE_DEPT_CASCADE_URL, DeptListType, params);
    }

    public static EocResultDTO<List<EocDeptEmployeeDTO>> getDepartEmployees(String deptId) {
        HashMap<String, String> param = new HashMap<String, String>();
        param.put("deptId", deptId);
        return (EocResultDTO)DwSpringHttpUtil.post((String)DEPT_EMPS_URL, param, EocDeptEmployeeDTOListType);
    }

    public static EocResultDTO<Map<Object, Object>> queryCurrentTenantAllDepartment() {
        HashMap<String, Integer> params = new HashMap<String, Integer>();
        params.put("pageSize", 2000);
        return (EocResultDTO)DwSpringHttpUtil.get((String)PAGE_DEPT_LIST_URL, MapType, params);
    }

    public static EocResultDTO<ProxyUserDTO> getProxyUser(String userId, String token) {
        DateTimeFormatter df = DateTimeFormatter.ofPattern("yyyy-MM-dd HH:mm:ss");
        HashMap<String, String> param = new HashMap<String, String>();
        param.put("userId", userId);
        param.put("agentDate", df.format(LocalDateTime.now()));
        return (EocResultDTO)DwSpringHttpUtil.post((String)EMP_AGENT_URL, param, ProxyUserDTOType, httpHeaders -> httpHeaders.add("digi-middleware-auth-user", token));
    }

    public static EocResultDTO<EocEmployeeDTO> getEmployee(String userId, String empId) {
        HashMap<String, Object> param = new HashMap<String, Object>();
        param.put("userId", userId);
        param.put("empId", empId);
        param.put("showException", false);
        return (EocResultDTO)DwSpringHttpUtil.post((String)EMP_INFO_URL, param, EocEmployeeDTOType);
    }

    public static EocResultDTO<EocUserDeptDTO> getDeptByUserId(String userId, Integer size) {
        HashMap<String, List<String>> params = new HashMap<String, List<String>>(2);
        params.put("userIds", Collections.singletonList(userId));
        HashMap<String, String> param = new HashMap<String, String>(2);
        param.put("pageSize", size.toString());
        param.put("params", JaJson.toString(params));
        return (EocResultDTO)DwSpringHttpUtil.get((String)PAGE_EMP_SIMPLE_URL, EocUserDeptType, param);
    }

    public static EocResultDTO<JSONArray> queryUserDepartmentInfo(String userId) {
        HashMap<String, String> param = new HashMap<String, String>(1);
        param.put("userId", userId);
        return (EocResultDTO)DwSpringHttpUtil.post((String)EMP_SUBORDINATE_URL, param, JSONArrayType);
    }

    public static EocResultDTO<List<EocCompanyDTO>> getUserDeptCompanyList(String userId, String token) {
        String url = EMP_DEPT_COMPANY_URL + userId;
        HashMap<String, String> headers = new HashMap<String, String>();
        headers.put("digi-middleware-auth-user", token);
        headers.put("token", token);
        return (EocResultDTO)DwSpringHttpUtil.get((String)url, EocCompanyDTOType, httpHeaders -> httpHeaders.setAll(headers), null);
    }
}

