package com.digiwin.athena.eoc.sdk.manager;

import com.alibaba.fastjson.JSONArray;
import com.digiwin.athena.common.sdk.manager.meta.constants.DwHttpHeaderConstants;
import com.digiwin.athena.common.sdk.manager.util.DwSpringHttpUtil;
import com.digiwin.athena.eoc.sdk.meta.dto.EocResultDTO;
import com.digiwin.athena.eoc.sdk.meta.dto.response.*;
import com.jugg.agile.framework.core.config.JaProperty;
import com.jugg.agile.framework.core.util.io.serialize.json.JaJson;
import org.springframework.core.ParameterizedTypeReference;

import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

/**
 * eoc 通用api
 *
 * @author gengwei
 * @since 2024/8/20 10:18
 */
public class EocCommonManager {

    private static String getCacUri() {
        return JaProperty.get("eoc.uri");
    }


    private static final ParameterizedTypeReference<EocResultDTO<List<ProxyUserDTO>>> ProxyUserDTOListType = new ParameterizedTypeReference<EocResultDTO<List<ProxyUserDTO>>>() {
    };
    private static final ParameterizedTypeReference<EocResultDTO<ProxyUserDTO>> ProxyUserDTOType = new ParameterizedTypeReference<EocResultDTO<ProxyUserDTO>>() {
    };
    private static final ParameterizedTypeReference<EocDeptDTO> DeptListType = new ParameterizedTypeReference<EocDeptDTO>() {
    };
    private static final ParameterizedTypeReference<EocResultDTO<List<EocDeptEmployeeDTO>>> EocDeptEmployeeDTOListType = new ParameterizedTypeReference<EocResultDTO<List<EocDeptEmployeeDTO>>>() {
    };
    private static final ParameterizedTypeReference<EocResultDTO<EocEmployeeDTO>> EocEmployeeDTOType = new ParameterizedTypeReference<EocResultDTO<EocEmployeeDTO>>() {
    };
    private static final ParameterizedTypeReference<EocResultDTO<Map<Object, Object>>> MapType = new ParameterizedTypeReference<EocResultDTO<Map<Object, Object>>>() {
    };
    private static final ParameterizedTypeReference<EocResultDTO<EocUserDeptDTO>> EocUserDeptType = new ParameterizedTypeReference<EocResultDTO<EocUserDeptDTO>>() {
    };
    private static final ParameterizedTypeReference<EocResultDTO<JSONArray>> JSONArrayType = new ParameterizedTypeReference<EocResultDTO<JSONArray>>() {
    };


    public static final String EMP_AGENT_TARGET_URL = getCacUri() + "api/eoc/v2/emp/agent/target";

    public static EocResultDTO<List<ProxyUserDTO>> getProxyTargetUsers(String userId, String token) {
        //获取员工ID
        Map<String, String> param = new HashMap<>(1);
        param.put("userId", userId);
        return DwSpringHttpUtil.post(EMP_AGENT_TARGET_URL, param, ProxyUserDTOListType, httpHeaders -> httpHeaders.add(DwHttpHeaderConstants.Header_User_Token, token));
    }


    /**
     * 查询所有部门信息以及部门下所有员工的信息【4.10】
     */
    public static final String PAGE_DEPT_CASCADE_URL = getCacUri() + "api/eoc/v2/dept/cascade?pageNum=1&pageSize={pageSize}";

    /**
     * 查询所有部门信息以及部门下所有员工的信息【4.10】
     */
    public static EocDeptDTO queryAllDeptAndEmployee() {
        Map<String, Object> params = new HashMap<>();
        params.put("pageSize", 2000);
        return DwSpringHttpUtil.get(PAGE_DEPT_CASCADE_URL, DeptListType, params);
    }

    /**
     * 根据部门id获取所有员工列表
     */
    public static final String DEPT_EMPS_URL = getCacUri() + "api/eoc/v2/dept/emps";

    /**
     * 根据部门id获取所有员工列表
     */
    public static EocResultDTO<List<EocDeptEmployeeDTO>> getDepartEmployees(String deptId) {
        Map<String, String> param = new HashMap<>();
        param.put("deptId", deptId);
        return DwSpringHttpUtil.post(DEPT_EMPS_URL, param, EocDeptEmployeeDTOListType);
    }

    /**
     * 根据token获取对应租户的所有部门及子部门
     */
    public static final String PAGE_DEPT_LIST_URL = getCacUri() + "api/eoc/v2/dept/list?pageNum=1&pageSize={pageSize}";


    public static EocResultDTO<Map<Object, Object>> queryCurrentTenantAllDepartment() {
        Map<String, Object> params = new HashMap<>();
        params.put("pageSize", 2000);
        return DwSpringHttpUtil.get(PAGE_DEPT_LIST_URL, MapType, params);
    }

    /**
     * 获取指定用户的代理用户
     */
    public static final String EMP_AGENT_URL = getCacUri() + "api/eoc/v2/emp/agent";

    public static EocResultDTO<ProxyUserDTO> getProxyUser(String userId, String token) {
        //获取员工ID
        DateTimeFormatter df = DateTimeFormatter.ofPattern("yyyy-MM-dd HH:mm:ss");
        //post body
        Map<String, String> param = new HashMap<>();
        param.put("userId", userId);
        param.put("agentDate", df.format(LocalDateTime.now()));
        return DwSpringHttpUtil.post(EMP_AGENT_URL, param, ProxyUserDTOType, httpHeaders -> httpHeaders.add(DwHttpHeaderConstants.Header_User_Token, token));

    }

    /**
     * 根据empId获取员工详情
     */
    public static final String EMP_INFO_URL = getCacUri() + "api/eoc/v2/emp/info";

    public static EocResultDTO<EocEmployeeDTO> getEmployee(String userId, String empId) {
        Map<String, Object> param = new HashMap<>();
        param.put("userId", userId);
        param.put("empId", empId);
        param.put("showException", false);
        return DwSpringHttpUtil.post(EMP_INFO_URL, param, EocEmployeeDTOType);
    }

    /**
     * 查找指定直属主管所属的人员列表
     */
    public static final String PAGE_EMP_SIMPLE_URL = getCacUri() + "api/eoc/v2/emp/simple?pageNum=1&pageSize={pageSize}&params={params}";


    /**
     * 获取用户的部门
     *
     * @param userId
     * @param size
     * @return
     */
    public static EocResultDTO<EocUserDeptDTO> getDeptByUserId(String userId, Integer size) {

        Map<String, Object> params = new HashMap<>(2);
        params.put("userIds", Collections.singletonList(userId));

        Map<String, String> param = new HashMap<>(2);
        param.put("pageSize", size.toString());
        param.put("params", JaJson.toString(params));

        return DwSpringHttpUtil.get(PAGE_EMP_SIMPLE_URL, EocUserDeptType, param);
    }

    /**
     * 根据用户查询用户所属部门以及子部门的员工列表
     */
    public static final String EMP_SUBORDINATE_URL = getCacUri() + "api/eoc/v2/emp/subordinate";

    /**
     * 根据用户查询用户所属部门以及子部门的员工列表
     *
     * @param userId 用户id
     * @return JSONArray
     */
    public static EocResultDTO<JSONArray> queryUserDepartmentInfo(String userId) {
        Map<String, String> param = new HashMap<>(1);
        param.put("userId", userId);
        return DwSpringHttpUtil.post(EMP_SUBORDINATE_URL, param, JSONArrayType);
    }


}
